/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.labels;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.event.EntityLabelEvent;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.event.LabelsRemovedEvent;
import com.wynntils.handlers.labels.event.TextDisplayChangedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.mc.event.SetEntityDataEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2945;
import net.minecraft.class_8113;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class LabelHandler
extends Handler {
    private final List<LabelParser> parsers = new ArrayList<LabelParser>();
    private final Map<Integer, LabelInfo> liveLabels = new HashMap<Integer, LabelInfo>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySetData(SetEntityDataEvent event) {
        this.handleTextDisplayEvents(event);
        this.handleEntityLabelEvents(event);
    }

    private void handleTextDisplayEvents(SetEntityDataEvent event) {
        class_1297 entity = McUtils.mc().field_1687.method_8469(event.getId());
        if (!(entity instanceof class_8113.class_8123)) {
            return;
        }
        class_8113.class_8123 textDisplay = (class_8113.class_8123)entity;
        for (class_2945.class_7834<?> packedItem : event.getPackedItems()) {
            StyledText newText;
            if (packedItem.comp_1115() != class_8113.class_8123.field_42435.comp_2327()) continue;
            class_2561 oldComponent = textDisplay.method_48915();
            class_2561 newComponent = (class_2561)packedItem.comp_1117();
            StyledText oldText = StyledText.fromComponent(oldComponent);
            if (oldText.equals(newText = StyledText.fromComponent(newComponent))) continue;
            LabelInfo labelInfo = this.tryIdentifyLabel(newText, entity);
            if (labelInfo != null) {
                this.liveLabels.put(entity.method_5628(), labelInfo);
            }
            TextDisplayChangedEvent.Text textChangedEvent = new TextDisplayChangedEvent.Text(textDisplay, labelInfo, newText);
            WynntilsMod.postEvent(textChangedEvent);
            if (textChangedEvent.isCanceled()) {
                event.removePackedItem(packedItem);
                continue;
            }
            if (textChangedEvent.getText().equals(newText)) continue;
            class_2945.class_7834 newTextData = new class_2945.class_7834(class_8113.class_8123.field_42435.comp_2327(), packedItem.comp_1116(), (Object)textChangedEvent.getText().getComponent());
            event.removePackedItem(packedItem);
            event.addPackedItem(newTextData);
        }
    }

    private void handleEntityLabelEvents(SetEntityDataEvent event) {
        class_1297 entity = McUtils.mc().field_1687.method_8469(event.getId());
        if (entity == null) {
            return;
        }
        for (class_2945.class_7834<?> packedItem : event.getPackedItems()) {
            Optional value;
            if (packedItem.comp_1115() == class_1297.field_5975.comp_2327()) {
                WynntilsMod.postEvent(new EntityLabelEvent.Visibility(entity, (Boolean)packedItem.comp_1117()));
                continue;
            }
            if (packedItem.comp_1115() != class_1297.field_6027.comp_2327() || (value = (Optional)packedItem.comp_1117()).isEmpty()) continue;
            class_2561 oldNameComponent = entity.method_5797();
            StyledText oldName = oldNameComponent != null ? StyledText.fromComponent(oldNameComponent) : StyledText.EMPTY;
            StyledText newName = StyledText.fromComponent((class_2561)value.get());
            if (newName.equals(oldName)) continue;
            EntityLabelEvent.Changed labelChangedEvent = new EntityLabelEvent.Changed(entity, newName);
            WynntilsMod.postEvent(labelChangedEvent);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitiesRemoved(RemoveEntitiesEvent event) {
        List<LabelInfo> removedLabels = this.liveLabels.values().stream().filter(label -> event.getEntityIds().contains(label.getEntity().method_5628())).toList();
        removedLabels.forEach(label -> this.liveLabels.remove(label.getEntity().method_5628()));
        WynntilsMod.postEvent(new LabelsRemovedEvent(removedLabels));
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        ArrayList<LabelInfo> oldLabels = new ArrayList<LabelInfo>(this.liveLabels.values());
        this.liveLabels.clear();
        WynntilsMod.postEvent(new LabelsRemovedEvent(oldLabels));
    }

    public void registerParser(LabelParser labelParser) {
        this.parsers.add(labelParser);
    }

    private LabelInfo tryIdentifyLabel(StyledText name, class_1297 entity) {
        for (LabelParser parser : this.parsers) {
            Object info = parser.getInfo(name, Location.containing((class_2374)entity.method_19538()), entity);
            if (info == null) continue;
            WynntilsMod.postEvent(new LabelIdentifiedEvent((LabelInfo)info));
            return info;
        }
        return null;
    }
}

