/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.crafted;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatListDelimiter;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public final class CraftedTooltipIdentifications {
    public static List<class_2561> buildTooltip(CraftedItemProperty craftedItem, ClassType currentClass, TooltipStyle style) {
        ArrayList<class_2561> identifications = new ArrayList<class_2561>();
        List<StatType> listOrdering = Models.Stat.getOrderingList(style.identificationOrdering());
        ArrayList<StatType> allStats = new ArrayList<StatType>(craftedItem.getStatTypes());
        if (allStats.isEmpty()) {
            return identifications;
        }
        boolean useDelimiters = style.useDelimiters();
        boolean delimiterNeeded = false;
        for (StatType statType : listOrdering) {
            class_5250 line;
            if (useDelimiters && statType instanceof StatListDelimiter && delimiterNeeded) {
                identifications.add((class_2561)class_2561.method_43470((String)""));
                delimiterNeeded = false;
            }
            if (!allStats.contains(statType) || (line = CraftedTooltipIdentifications.getStatLine(statType, craftedItem, currentClass, style)) == null) continue;
            identifications.add((class_2561)line);
            delimiterNeeded = true;
        }
        if (!identifications.isEmpty() && ((class_2561)identifications.getLast()).getString().isEmpty()) {
            identifications.removeLast();
        }
        return identifications;
    }

    private static class_5250 getStatLine(StatType statType, CraftedItemProperty craftedItem, ClassType currentClass, TooltipStyle style) {
        StatActualValue statActualValue = craftedItem.getIdentifications().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
        if (statActualValue == null) {
            WynntilsMod.warn("Missing value in item " + craftedItem.getName() + " for stat: " + String.valueOf(statType));
            return null;
        }
        class_5250 line = CraftedTooltipIdentifications.buildIdentifiedLine(craftedItem, style, statActualValue, currentClass);
        return line;
    }

    private static class_5250 buildIdentifiedLine(CraftedItemProperty craftedItem, TooltipStyle style, StatActualValue actualValue, ClassType currentClass) {
        StatType statType = actualValue.statType();
        int value = actualValue.value();
        int valueToShow = statType.calculateAsInverted() ? -value : value;
        boolean hasPositiveEffect = valueToShow > 0 ^ statType.displayAsInverted();
        class_5250 line = class_2561.method_43470((String)(StringUtils.toSignedString(valueToShow) + statType.getUnit().getDisplayName())).method_27696(class_2583.field_24360.method_10977(hasPositiveEffect ? class_124.field_1060 : class_124.field_1061));
        if (style.showMaxValue() && !(craftedItem instanceof CraftedConsumableItem)) {
            craftedItem.getPossibleValues().stream().filter(possibleValues -> possibleValues.statType() == statType).findFirst().ifPresent(possibleValues -> line.method_10852((class_2561)class_2561.method_43470((String)("/" + StringUtils.toSignedString(possibleValues.range().high()) + statType.getUnit().getDisplayName())).method_27692(class_124.field_1063)));
        }
        line.method_10852((class_2561)class_2561.method_43470((String)(" " + Models.Stat.getDisplayName(statType, craftedItem.getRequiredClass(), currentClass, RangedValue.NONE))).method_27692(class_124.field_1080));
        return line;
    }
}

