/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable;

import com.wynntils.core.components.Services;
import com.wynntils.handlers.tooltip.TooltipBuilder;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.handlers.tooltip.impl.identifiable.TooltipIdentifications;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.handlers.tooltip.type.TooltipWeightDecorator;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.ItemWeightSource;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.services.itemweight.ItemWeightService;
import com.wynntils.services.itemweight.type.ItemWeighting;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class IdentifiableTooltipBuilder<T, U>
extends TooltipBuilder {
    private final IdentifiableItemProperty<T, U> itemInfo;

    private IdentifiableTooltipBuilder(IdentifiableItemProperty<T, U> itemInfo, List<class_2561> header, List<class_2561> footer, String source) {
        super(header, footer, source);
        this.itemInfo = itemInfo;
    }

    private IdentifiableTooltipBuilder(IdentifiableItemProperty<T, U> itemInfo, List<class_2561> header, List<class_2561> footer) {
        this(itemInfo, header, footer, "");
    }

    public static <T, U> IdentifiableTooltipBuilder<T, U> buildNewItem(IdentifiableItemProperty<T, U> identifiableItem, IdentifiableTooltipComponent<T, U> tooltipComponent, boolean hideUnidentified, boolean showItemType, String source) {
        T itemInfo = identifiableItem.getItemInfo();
        Object itemInstance = identifiableItem.getItemInstance().orElse(null);
        List<class_2561> header = tooltipComponent.buildHeaderTooltip(itemInfo, itemInstance, hideUnidentified);
        List<class_2561> footer = tooltipComponent.buildFooterTooltip(itemInfo, itemInstance, showItemType);
        return new IdentifiableTooltipBuilder<T, U>(identifiableItem, header, footer, source);
    }

    public static IdentifiableTooltipBuilder fromParsedItemStack(class_1799 itemStack, IdentifiableItemProperty itemInfo) {
        List<class_2561> tooltips = LoreUtils.getTooltipLines(itemStack);
        Pair<List<class_2561>, List<class_2561>> splitLore = IdentifiableTooltipBuilder.extractHeaderAndFooter(tooltips);
        List<class_2561> header = splitLore.a();
        List<class_2561> footer = splitLore.b();
        return new IdentifiableTooltipBuilder(itemInfo, header, footer);
    }

    @Override
    protected List<class_2561> getWeightedHeaderLines(List<class_2561> originalHeader, ItemWeightSource weightSource, TooltipWeightDecorator weightDecorator, TooltipStyle style) {
        T t;
        if (weightSource == ItemWeightSource.NONE || !this.itemInfo.hasOverallValue() || !((t = this.itemInfo.getItemInfo()) instanceof GearInfo)) {
            return originalHeader;
        }
        GearInfo gearInfo = (GearInfo)t;
        List<ItemWeighting> noriWeightings = Services.ItemWeight.getItemWeighting(gearInfo.name(), ItemWeightSource.NORI);
        List<ItemWeighting> wynnpoolWeightings = Services.ItemWeight.getItemWeighting(gearInfo.name(), ItemWeightSource.WYNNPOOL);
        boolean addNori = (weightSource == ItemWeightSource.NORI || weightSource == ItemWeightSource.ALL) && !noriWeightings.isEmpty();
        boolean addWynnpool = (weightSource == ItemWeightSource.WYNNPOOL || weightSource == ItemWeightSource.ALL) && !wynnpoolWeightings.isEmpty();
        int currentIndex = 1;
        ArrayList<class_2561> weightedHeader = new ArrayList<class_2561>(originalHeader);
        if (addNori) {
            weightedHeader.add(currentIndex, ItemWeightService.NORI_HEADER);
            ++currentIndex;
            currentIndex = this.addWeightingLines(weightedHeader, noriWeightings, weightDecorator, currentIndex);
        }
        if (addWynnpool) {
            weightedHeader.add(currentIndex, ItemWeightService.WYNNPOOL_HEADER);
            ++currentIndex;
            currentIndex = this.addWeightingLines(weightedHeader, wynnpoolWeightings, weightDecorator, currentIndex);
        }
        if ((addNori || addWynnpool) && gearInfo.type().isWeapon()) {
            weightedHeader.add(currentIndex, (class_2561)class_2561.method_43473());
        }
        return weightedHeader;
    }

    private int addWeightingLines(List<class_2561> originalHeader, List<ItemWeighting> weightings, TooltipWeightDecorator weightDecorator, int currentIndex) {
        for (ItemWeighting weighting : weightings) {
            for (class_5250 component : weightDecorator.getLines(weighting, this.itemInfo)) {
                originalHeader.add(currentIndex, (class_2561)component);
                ++currentIndex;
            }
        }
        return currentIndex;
    }

    @Override
    protected List<class_2561> getIdentificationLines(ClassType currentClass, TooltipStyle style, TooltipIdentificationDecorator decorator) {
        return TooltipIdentifications.buildTooltip(this.itemInfo, currentClass, decorator, style);
    }
}

