/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable.components;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.rewards.type.CharmInfo;
import com.wynntils.models.rewards.type.CharmInstance;
import com.wynntils.models.rewards.type.CharmRequirements;
import com.wynntils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CharmTooltipComponent
extends IdentifiableTooltipComponent<CharmInfo, CharmInstance> {
    @Override
    public List<class_2561> buildHeaderTooltip(CharmInfo charmInfo, CharmInstance charmInstance, boolean hideUnidentified) {
        ArrayList<class_2561> header = new ArrayList<class_2561>();
        String prefix = charmInstance == null && !hideUnidentified ? "Unidentified " : "";
        header.add((class_2561)class_2561.method_43470((String)(prefix + charmInfo.name())).method_27692(charmInfo.tier().getChatFormatting()));
        header.add((class_2561)class_2561.method_43470((String)"Keep in inventory to gain bonus").method_27692(class_124.field_1080));
        header.add((class_2561)class_2561.method_43473());
        CharmRequirements requirements = charmInfo.requirements();
        int level = requirements.level();
        if (level != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= level;
            header.add((class_2561)this.buildRequirementLine("Combat Lv. Min: " + level, fulfilled));
            header.add((class_2561)class_2561.method_43473());
        }
        return header;
    }

    @Override
    public List<class_2561> buildFooterTooltip(CharmInfo charmInfo, CharmInstance charmInstance, boolean showItemType) {
        ArrayList<class_2561> footer = new ArrayList<class_2561>();
        footer.add((class_2561)class_2561.method_43473());
        GearTier gearTier = charmInfo.tier();
        class_5250 itemTypeName = showItemType ? class_2561.method_43470((String)"Charm") : class_2561.method_43470((String)"Raid Reward");
        class_5250 tier = class_2561.method_43470((String)gearTier.getName()).method_27692(gearTier.getChatFormatting()).method_27693(" ").method_10852((class_2561)itemTypeName);
        if (charmInstance != null && charmInstance.rerolls() > 1) {
            tier.method_27693(" [" + charmInstance.rerolls() + "]");
        }
        footer.add((class_2561)tier);
        if (charmInfo.metaInfo().restrictions() != GearRestrictions.NONE) {
            footer.add((class_2561)class_2561.method_43470((String)StringUtils.capitalizeFirst(charmInfo.metaInfo().restrictions().getDescription())).method_27692(class_124.field_1061));
        }
        return footer;
    }
}

