/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.tree.RootCommandNode;
import com.wynntils.core.events.MixinHelper;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.AddEntityEvent;
import com.wynntils.mc.event.AdvancementUpdateEvent;
import com.wynntils.mc.event.ChatSentEvent;
import com.wynntils.mc.event.ChunkReceivedEvent;
import com.wynntils.mc.event.CommandSentEvent;
import com.wynntils.mc.event.CommandsAddedEvent;
import com.wynntils.mc.event.ConnectionEvent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.EntityPositionSyncEvent;
import com.wynntils.mc.event.LocalSoundEvent;
import com.wynntils.mc.event.MenuEvent;
import com.wynntils.mc.event.MobEffectEvent;
import com.wynntils.mc.event.ParticleAddedEvent;
import com.wynntils.mc.event.PlayerInfoEvent;
import com.wynntils.mc.event.PlayerInfoFooterChangedEvent;
import com.wynntils.mc.event.PlayerInfoUpdateEvent;
import com.wynntils.mc.event.PlayerTeleportEvent;
import com.wynntils.mc.event.PongReceivedEvent;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.mc.event.ScoreboardEvent;
import com.wynntils.mc.event.ScoreboardSetDisplayObjectiveEvent;
import com.wynntils.mc.event.ScoreboardSetObjectiveEvent;
import com.wynntils.mc.event.SetEntityDataEvent;
import com.wynntils.mc.event.SetEntityPassengersEvent;
import com.wynntils.mc.event.SetPlayerTeamEvent;
import com.wynntils.mc.event.SetSpawnEvent;
import com.wynntils.mc.event.SubtitleSetTextEvent;
import com.wynntils.mc.event.TitleSetTextEvent;
import com.wynntils.mc.mixin.accessors.ClientboundPlayerInfoUpdatePacketAccessor;
import com.wynntils.mc.mixin.accessors.ClientboundSetPlayerTeamPacketAccessor;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_10264;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2604;
import net.minecraft.class_2641;
import net.minecraft.class_2645;
import net.minecraft.class_2649;
import net.minecraft.class_2653;
import net.minecraft.class_2672;
import net.minecraft.class_2675;
import net.minecraft.class_2678;
import net.minecraft.class_2703;
import net.minecraft.class_2708;
import net.minecraft.class_2716;
import net.minecraft.class_2718;
import net.minecraft.class_2736;
import net.minecraft.class_2739;
import net.minecraft.class_2751;
import net.minecraft.class_2752;
import net.minecraft.class_2757;
import net.minecraft.class_2759;
import net.minecraft.class_2767;
import net.minecraft.class_2772;
import net.minecraft.class_2779;
import net.minecraft.class_2783;
import net.minecraft.class_2923;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3944;
import net.minecraft.class_434;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_5900;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7828;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import net.minecraft.class_9006;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_634.class})
public abstract class ClientPacketListenerMixin
extends class_8673 {
    @Shadow
    private CommandDispatcher<class_2172> field_3696;
    @Shadow
    private class_5455.class_6890 field_25063;
    @Shadow
    @Final
    private class_7699 field_45600;

    @Shadow
    protected abstract ParseResults<class_2172> method_45733(String var1);

    protected ClientPacketListenerMixin(class_310 minecraft, class_2535 connection, class_8675 commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Unique
    private static boolean isRenderThread() {
        return McUtils.mc().method_18854();
    }

    @Inject(method={"sendChat(Ljava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onChatPre(String string, CallbackInfo ci) {
        ChatSentEvent event = new ChatSentEvent(string);
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"sendCommand(Ljava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSignedCommandPre(String string, CallbackInfo ci) {
        CommandSentEvent event = new CommandSentEvent(string, true);
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"sendUnsignedCommand(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUnsignedCommandPre(String command, CallbackInfoReturnable<Boolean> cir) {
        CommandSentEvent event = new CommandSentEvent(command, false);
        MixinHelper.post(event);
        if (event.isCanceled()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"handleCommands(Lnet/minecraft/network/protocol/game/ClientboundCommandsPacket;)V"}, at={@At(value="RETURN")})
    private void handleCommandsPost(class_2641 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        RootCommandNode root = this.field_3696.getRoot();
        CommandsAddedEvent event = new CommandsAddedEvent((RootCommandNode<class_2172>)root, class_7157.method_46722((class_7225.class_7874)this.field_25063, (class_7699)this.field_45600));
        MixinHelper.post(event);
        if (event.getRoot() != root) {
            this.field_3696 = new CommandDispatcher(event.getRoot());
        }
    }

    @Inject(method={"handlePlayerInfoUpdate(Lnet/minecraft/network/protocol/game/ClientboundPlayerInfoUpdatePacket;)V"}, at={@At(value="HEAD")})
    private void handlePlayerInfoUpdatePre(class_2703 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        if (!MixinHelper.onWynncraft()) {
            return;
        }
        PlayerInfoUpdateEvent e = new PlayerInfoUpdateEvent(packet.method_46329(), packet.method_46330());
        MixinHelper.post(e);
        if (e.getEntries() != packet.method_46329()) {
            ((ClientboundPlayerInfoUpdatePacketAccessor)packet).setEntries(e.getEntries());
        }
    }

    @Inject(method={"handlePlayerInfoUpdate(Lnet/minecraft/network/protocol/game/ClientboundPlayerInfoUpdatePacket;)V"}, at={@At(value="RETURN")})
    private void handlePlayerInfoUpdatePost(class_2703 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        if (!MixinHelper.onWynncraft()) {
            return;
        }
        for (class_2703.class_2705 entry : packet.method_46330()) {
            GameProfile profile = entry.comp_1107();
            if (profile == null) continue;
            MixinHelper.post(new PlayerInfoEvent.PlayerLogInEvent(profile.getId(), profile.getName()));
        }
        for (class_2703.class_2705 entry : packet.method_46329()) {
            for (class_2703.class_5893 action : packet.method_46327()) {
                if (action != class_2703.class_5893.field_29139 || entry.comp_1111() == null) continue;
                MixinHelper.post(new PlayerInfoEvent.PlayerDisplayNameChangeEvent(entry.comp_1106(), entry.comp_1111()));
            }
        }
    }

    @Inject(method={"handlePlayerInfoRemove(Lnet/minecraft/network/protocol/game/ClientboundPlayerInfoRemovePacket;)V"}, at={@At(value="RETURN")})
    private void handlePlayerInfoRemovePost(class_7828 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        if (!MixinHelper.onWynncraft()) {
            return;
        }
        for (UUID uuid : packet.comp_1105()) {
            MixinHelper.post(new PlayerInfoEvent.PlayerLogOutEvent(uuid));
        }
    }

    @Inject(method={"handleTabListCustomisation(Lnet/minecraft/network/protocol/game/ClientboundTabListPacket;)V"}, at={@At(value="RETURN")})
    private void handleTabListCustomisationPost(class_2772 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new PlayerInfoFooterChangedEvent(StyledText.fromComponent(packet.comp_2283())));
    }

    @Inject(method={"handleMovePlayer(Lnet/minecraft/network/protocol/game/ClientboundPlayerPositionPacket;)V"}, at={@At(value="HEAD")})
    private void handleMovePlayerPost(class_2708 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        if (!packet.comp_3229().isEmpty()) {
            return;
        }
        MixinHelper.post(new PlayerTeleportEvent((class_2374)new class_243(packet.comp_3228().comp_3148().method_10216(), packet.comp_3228().comp_3148().method_10214(), packet.comp_3228().comp_3148().method_10215())));
    }

    @Inject(method={"handleOpenScreen(Lnet/minecraft/network/protocol/game/ClientboundOpenScreenPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleOpenScreenPre(class_3944 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MenuEvent.MenuOpenedEvent.Pre event = new MenuEvent.MenuOpenedEvent.Pre(packet.method_17593(), packet.method_17594(), packet.method_17592());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleOpenScreen(Lnet/minecraft/network/protocol/game/ClientboundOpenScreenPacket;)V"}, at={@At(value="RETURN")})
    private void handleOpenScreenPost(class_3944 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MenuEvent.MenuOpenedEvent.Post event = new MenuEvent.MenuOpenedEvent.Post(packet.method_17593(), packet.method_17594(), packet.method_17592());
        MixinHelper.post(event);
    }

    @Inject(method={"handleContainerClose(Lnet/minecraft/network/protocol/game/ClientboundContainerClosePacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleContainerClosePre(class_2645 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MenuEvent.MenuClosedEvent event = new MenuEvent.MenuClosedEvent(packet.method_36148());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleContainerContent(Lnet/minecraft/network/protocol/game/ClientboundContainerSetContentPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleContainerContentPre(class_2649 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        ContainerSetContentEvent.Pre event = new ContainerSetContentEvent.Pre(packet.method_11441(), packet.method_37437(), packet.method_11440(), packet.method_37438());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
        if (!packet.method_11441().equals(event.getItems())) {
            if (packet.method_11440() == 0) {
                McUtils.player().field_7498.method_7610(packet.method_37438(), packet.method_11441(), packet.method_37437());
            } else if (packet.method_11440() == McUtils.containerMenu().field_7763) {
                McUtils.player().field_7512.method_7610(packet.method_37438(), packet.method_11441(), packet.method_37437());
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleContainerContent(Lnet/minecraft/network/protocol/game/ClientboundContainerSetContentPacket;)V"}, at={@At(value="RETURN")})
    private void handleContainerContentPost(class_2649 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new ContainerSetContentEvent.Post(packet.method_11441(), packet.method_37437(), packet.method_11440(), packet.method_37438()));
    }

    @Inject(method={"handleContainerSetSlot(Lnet/minecraft/network/protocol/game/ClientboundContainerSetSlotPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleContainerSetSlotPre(class_2653 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        ContainerSetSlotEvent.Pre event = new ContainerSetSlotEvent.Pre(packet.method_11452(), packet.method_37439(), packet.method_11450(), packet.method_11449());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleContainerSetSlot(Lnet/minecraft/network/protocol/game/ClientboundContainerSetSlotPacket;)V"}, at={@At(value="RETURN")})
    private void handleContainerSetSlotPost(class_2653 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new ContainerSetSlotEvent.Post(packet.method_11452(), packet.method_37439(), packet.method_11450(), packet.method_11449()));
    }

    @Inject(method={"handleSetPlayerTeamPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPlayerTeamPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSetPlayerTeamPacketPre(class_5900 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        SetPlayerTeamEvent event = new SetPlayerTeamEvent(((ClientboundSetPlayerTeamPacketAccessor)packet).getMethod(), packet.method_34177());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSetEntityPassengersPacketPre(class_2752 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        SetEntityPassengersEvent event = new SetEntityPassengersEvent(packet.method_11841());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleSetSpawn(Lnet/minecraft/network/protocol/game/ClientboundSetDefaultSpawnPositionPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSetSpawnPre(class_2759 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        SetSpawnEvent event = new SetSpawnEvent(packet.method_11870());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
            class_437 class_4372 = McUtils.screen();
            if (class_4372 instanceof class_434) {
                class_434 receivingLevelScreen = (class_434)class_4372;
                receivingLevelScreen.method_25419();
            }
        }
    }

    @Inject(method={"setTitleText(Lnet/minecraft/network/protocol/game/ClientboundSetTitleTextPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setTitleTextPre(class_5904 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        TitleSetTextEvent event = new TitleSetTextEvent(packet.comp_2281());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"setSubtitleText(Lnet/minecraft/network/protocol/game/ClientboundSetSubtitleTextPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSubtitleTextPre(class_5903 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        SubtitleSetTextEvent event = new SubtitleSetTextEvent(packet.comp_2280());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleAddObjective(Lnet/minecraft/network/protocol/game/ClientboundSetObjectivePacket;)V"}, at={@At(value="RETURN")})
    private void handleAddObjective(class_2751 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        ScoreboardSetObjectiveEvent event = new ScoreboardSetObjectiveEvent(packet.method_11835(), packet.method_11836(), packet.method_11839(), packet.method_11837());
        MixinHelper.post(event);
    }

    @Inject(method={"handleSetScore(Lnet/minecraft/network/protocol/game/ClientboundSetScorePacket;)V"}, at={@At(value="RETURN")})
    private void handleSetScore(class_2757 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        ScoreboardEvent.Set event = new ScoreboardEvent.Set(StyledText.fromString(packet.comp_2122()), packet.comp_2123(), packet.comp_2124());
        MixinHelper.post(event);
    }

    @Inject(method={"handleResetScore(Lnet/minecraft/network/protocol/game/ClientboundResetScorePacket;)V"}, at={@At(value="RETURN")})
    private void handleResetScore(class_9006 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        ScoreboardEvent.Reset event = new ScoreboardEvent.Reset(StyledText.fromString(packet.comp_2120()), packet.comp_2121());
        MixinHelper.post(event);
    }

    @Inject(method={"handleSetDisplayObjective(Lnet/minecraft/network/protocol/game/ClientboundSetDisplayObjectivePacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSetDisplayObjective(class_2736 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        ScoreboardSetDisplayObjectiveEvent event = new ScoreboardSetDisplayObjectiveEvent(packet.method_11806(), packet.method_11804());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleUpdateAdvancementsPacket(Lnet/minecraft/network/protocol/game/ClientboundUpdateAdvancementsPacket;)V"}, at={@At(value="RETURN")})
    private void handleUpdateAdvancementsPacket(class_2779 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new AdvancementUpdateEvent(packet.method_11924(), packet.method_11928(), packet.method_11926(), packet.method_11927()));
    }

    @Inject(method={"handleUpdateMobEffect(Lnet/minecraft/network/protocol/game/ClientboundUpdateMobEffectPacket;)V"}, at={@At(value="RETURN")})
    private void handleUpdateMobEffectPost(class_2783 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        if (!MixinHelper.onWynncraft()) {
            return;
        }
        MixinHelper.post(new MobEffectEvent.Update(McUtils.mc().field_1687.method_8469(packet.method_11943()), (class_1291)packet.method_11946().comp_349(), packet.method_11945(), packet.method_11944()));
    }

    @Inject(method={"handleRemoveMobEffect(Lnet/minecraft/network/protocol/game/ClientboundRemoveMobEffectPacket;)V"}, at={@At(value="RETURN")})
    private void handleRemoveMobEffectPost(class_2718 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new MobEffectEvent.Remove(packet.method_11767((class_1937)McUtils.mc().field_1687), (class_1291)packet.comp_2176().comp_349()));
    }

    @Inject(method={"handleAddEntity(Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;postAddEntitySoundInstance(Lnet/minecraft/world/entity/Entity;)V", shift=At.Shift.AFTER)})
    private void handleAddEntity(class_2604 packet, CallbackInfo ci, @Local class_1297 entity) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new AddEntityEvent(packet, entity));
    }

    @Inject(method={"handleEntityPositionSync(Lnet/minecraft/network/protocol/game/ClientboundEntityPositionSyncPacket;)V"}, at={@At(value="RETURN")})
    private void handleEntityPositionSync(class_10264 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        class_1297 entity = McUtils.mc().field_1687.method_8469(packet.comp_3223());
        if (entity == null) {
            return;
        }
        MixinHelper.post(new EntityPositionSyncEvent(entity, packet.comp_3224().comp_3148()));
    }

    @ModifyArg(method={"handleSetEntityData(Lnet/minecraft/network/protocol/game/ClientboundSetEntityDataPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;assignValues(Ljava/util/List;)V"), index=0)
    private List<class_2945.class_7834<?>> handleSetEntityDataPre(List<class_2945.class_7834<?>> packedItems, @Local(argsOnly=true) class_2739 packet) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return packedItems;
        }
        SetEntityDataEvent event = new SetEntityDataEvent(packet);
        MixinHelper.post(event);
        return event.getPackedItems();
    }

    @Inject(method={"handleRemoveEntities(Lnet/minecraft/network/protocol/game/ClientboundRemoveEntitiesPacket;)V"}, at={@At(value="RETURN")})
    private void handleRemoveEntities(class_2716 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new RemoveEntitiesEvent(packet));
    }

    @Inject(method={"handleSoundEvent(Lnet/minecraft/network/protocol/game/ClientboundSoundPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSoundEventPre(class_2767 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        LocalSoundEvent.Client event = new LocalSoundEvent.Client((class_3414)packet.method_11894().comp_349(), packet.method_11888());
        MixinHelper.post(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleParticleEvent(Lnet/minecraft/network/protocol/game/ClientboundLevelParticlesPacket;)V"}, at={@At(value="HEAD")})
    private void handleParticles(class_2675 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new ParticleAddedEvent(packet));
    }

    @Inject(method={"handleLevelChunkWithLight(Lnet/minecraft/network/protocol/game/ClientboundLevelChunkWithLightPacket;)V"}, at={@At(value="RETURN")})
    private void handleLevelChunkWithLight(class_2672 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.post(new ChunkReceivedEvent(packet.method_11523(), packet.method_11524(), packet.method_38598(), packet.method_38599()));
    }

    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="RETURN")})
    private void handleLoginPost(class_2678 packet, CallbackInfo ci) {
        if (!ClientPacketListenerMixin.isRenderThread()) {
            return;
        }
        MixinHelper.postAlways(new ConnectionEvent.ConnectedEvent());
    }

    @Inject(method={"handlePongResponse(Lnet/minecraft/network/protocol/ping/ClientboundPongResponsePacket;)V"}, at={@At(value="RETURN")})
    private void handlePongResponsePost(class_2923 packet, CallbackInfo ci) {
        PongReceivedEvent event = new PongReceivedEvent(packet.comp_2201());
        MixinHelper.post(event);
    }
}

