/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilitytree.type;

import com.google.common.collect.ComparisonChain;

public record AbilityTreeLocation(int page, int row, int col) implements Comparable<AbilityTreeLocation>
{
    private static final int MAX_ROWS = 6;
    private static final int MAX_COLS = 9;

    public static AbilityTreeLocation fromSlot(int slot, int page) {
        int row = slot / 9;
        int col = slot % 9;
        return new AbilityTreeLocation(page, row, col);
    }

    private int getAbsoluteRow() {
        return (this.page - 1) * 6 + this.row;
    }

    public boolean isNeighbor(AbilityTreeLocation other) {
        return this.getAbsoluteRow() == other.getAbsoluteRow() && Math.abs(this.col - other.col) == 1 || this.col == other.col && Math.abs(this.getAbsoluteRow() - other.getAbsoluteRow()) == 1;
    }

    public AbilityTreeLocation up() {
        if (this.row == 0) {
            return null;
        }
        return new AbilityTreeLocation(this.page, this.row - 1, this.col);
    }

    public AbilityTreeLocation down() {
        if (this.row + 1 == 6) {
            return new AbilityTreeLocation(this.page + 1, 0, this.col);
        }
        return new AbilityTreeLocation(this.page, this.row + 1, this.col);
    }

    public AbilityTreeLocation left() {
        if (this.col == 0) {
            return null;
        }
        return new AbilityTreeLocation(this.page, this.row, this.col - 1);
    }

    public AbilityTreeLocation right() {
        if (this.col + 1 == 9) {
            return null;
        }
        return new AbilityTreeLocation(this.page, this.row, this.col + 1);
    }

    @Override
    public int compareTo(AbilityTreeLocation other) {
        return ComparisonChain.start().compare(this.getAbsoluteRow(), other.getAbsoluteRow()).compare(this.col, other.col).result();
    }
}

