/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.containers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.event.BankPageSetEvent;
import com.wynntils.models.containers.type.BankPageCustomization;
import com.wynntils.models.containers.type.PersonalStorageType;
import com.wynntils.models.containers.type.QuickJumpButtonIcon;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class BankModel
extends Model {
    @Persisted
    private final Storage<Integer> finalAccountBankPage = new Storage<Integer>(21);
    @Persisted
    private final Storage<Integer> finalBlockBankPage = new Storage<Integer>(12);
    @Persisted
    private final Storage<Integer> finalBookshelfPage = new Storage<Integer>(10);
    @Persisted
    private final Storage<Integer> finalMiscBucketPage = new Storage<Integer>(10);
    @Persisted
    private final Storage<Map<String, Integer>> finalCharacterBankPages = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, BankPageCustomization>> customAccountBankPageCustomizations = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, BankPageCustomization>> customBlockBankPageCustomizations = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, BankPageCustomization>> customBookshelfPageCustomizations = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<Integer, BankPageCustomization>> customMiscBucketPageCustomizations = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<String, Map<Integer, BankPageCustomization>>> customCharacterBankPagesCustomizations = new Storage(new TreeMap());
    public static final int QUICK_JUMP_SLOT = 7;
    private static final String FINAL_PAGE_NAME = "\udb3f\udfff";
    private static final int MAX_CHARACTER_BANK_PAGES = 12;
    private static final StyledText LAST_BANK_PAGE_STRING = StyledText.fromString(">\u00a74>\u00a7c>\u00a74>\u00a7c>");
    private boolean editingMode;
    private boolean updatedPage;
    private int currentPage = 1;
    private PersonalStorageContainer personalStorageContainer = null;
    private PersonalStorageType storageContainerType = null;

    public BankModel() {
        super(List.of());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onScreenInit(ScreenInitEvent.Pre e) {
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof PersonalStorageContainer)) {
            this.storageContainerType = null;
            return;
        }
        PersonalStorageContainer container2 = (PersonalStorageContainer)container;
        this.personalStorageContainer = container2;
        this.storageContainerType = this.personalStorageContainer.getPersonalStorageType();
        this.editingMode = false;
        this.updatedPage = false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScreenClose(ScreenClosedEvent.Post e) {
        this.storageContainerType = null;
        this.currentPage = 1;
        this.editingMode = false;
        this.updatedPage = false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onContainerSetContent(ContainerSetContentEvent.Pre event) {
        if (this.storageContainerType == null) {
            return;
        }
        class_1799 previousPageItem = event.getItems().get(this.personalStorageContainer.getPreviousItemSlot());
        class_1799 nextPageItem = event.getItems().get(this.personalStorageContainer.getNextItemSlot());
        this.updateState(previousPageItem, nextPageItem);
        this.updatedPage = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre event) {
        if (this.storageContainerType == null) {
            return;
        }
        if (!this.updatedPage) {
            return;
        }
        if (event.getSlot() == this.personalStorageContainer.getPreviousItemSlot()) {
            this.updateState(event.getItemStack(), class_1799.field_8037);
        }
        if (event.getSlot() == this.personalStorageContainer.getNextItemSlot()) {
            this.updateState(class_1799.field_8037, event.getItemStack());
        }
    }

    public BankPageCustomization getPageCustomization(int page) {
        Map<Integer, BankPageCustomization> pageNamesMap = this.getCurrentCustomizationMap();
        if (pageNamesMap == null) {
            return new BankPageCustomization(page);
        }
        return pageNamesMap.getOrDefault(page, new BankPageCustomization(page));
    }

    public void saveCurrentPageName(String nameToSet) {
        this.updatePageCustomization(this.currentPage, customPageCustomization -> customPageCustomization.setName(nameToSet));
    }

    public void savePageIcon(Integer pageIndex, QuickJumpButtonIcon iconToSet) {
        this.updatePageCustomization(pageIndex, customPageCustomization -> customPageCustomization.setIcon(iconToSet));
    }

    private void updatePageCustomization(Integer pageIndex, Consumer<BankPageCustomization> updater) {
        switch (this.storageContainerType) {
            case ACCOUNT_BANK: {
                this.updatePageCustomization(pageIndex, updater, this.customAccountBankPageCustomizations);
                break;
            }
            case BLOCK_BANK: {
                this.updatePageCustomization(pageIndex, updater, this.customBlockBankPageCustomizations);
                break;
            }
            case BOOKSHELF: {
                this.updatePageCustomization(pageIndex, updater, this.customBookshelfPageCustomizations);
                break;
            }
            case CHARACTER_BANK: {
                ((Map)this.customCharacterBankPagesCustomizations.get()).putIfAbsent(Models.Character.getId(), new TreeMap());
                Map nameMap = (Map)((Map)this.customCharacterBankPagesCustomizations.get()).get(Models.Character.getId());
                BankPageCustomization cusomization = nameMap.getOrDefault(pageIndex, new BankPageCustomization(pageIndex));
                updater.accept(cusomization);
                if (cusomization.equals(new BankPageCustomization(pageIndex))) {
                    nameMap.remove(pageIndex);
                } else {
                    nameMap.put(pageIndex, cusomization);
                }
                ((Map)this.customCharacterBankPagesCustomizations.get()).put(Models.Character.getId(), nameMap);
                this.customCharacterBankPagesCustomizations.touched();
                break;
            }
            case MISC_BUCKET: {
                this.updatePageCustomization(pageIndex, updater, this.customMiscBucketPageCustomizations);
            }
        }
    }

    private void updatePageCustomization(Integer pageIndex, Consumer<BankPageCustomization> updater, Storage<Map<Integer, BankPageCustomization>> storage) {
        BankPageCustomization cusomization = ((Map)storage.get()).getOrDefault(pageIndex, new BankPageCustomization(pageIndex));
        updater.accept(cusomization);
        if (cusomization.equals(new BankPageCustomization(pageIndex))) {
            ((Map)storage.get()).remove(pageIndex);
        } else {
            ((Map)storage.get()).put(pageIndex, cusomization);
        }
        storage.touched();
    }

    public void resetCurrentPageName() {
        this.saveCurrentPageName(class_1074.method_4662((String)"feature.wynntils.personalStorageUtilities.page", (Object[])new Object[]{this.currentPage}));
    }

    public int getFinalPage() {
        return switch (this.storageContainerType) {
            default -> throw new MatchException(null, null);
            case PersonalStorageType.ACCOUNT_BANK -> (Integer)this.finalAccountBankPage.get();
            case PersonalStorageType.BLOCK_BANK -> (Integer)this.finalBlockBankPage.get();
            case PersonalStorageType.BOOKSHELF -> (Integer)this.finalBookshelfPage.get();
            case PersonalStorageType.CHARACTER_BANK -> ((Map)this.finalCharacterBankPages.get()).getOrDefault(Models.Character.getId(), 12);
            case PersonalStorageType.MISC_BUCKET -> (Integer)this.finalMiscBucketPage.get();
        };
    }

    public PersonalStorageType getStorageContainerType() {
        return this.storageContainerType;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean isEditingMode() {
        return this.editingMode;
    }

    public void toggleEditingMode(boolean editingMode) {
        this.editingMode = editingMode;
    }

    private void updateState(class_1799 previousPageItem, class_1799 nextPageItem) {
        Matcher nextPageMatcher;
        Matcher previousPageMatcher = StyledText.fromComponent(previousPageItem.method_7964()).getMatcher(this.personalStorageContainer.getPreviousItemPattern());
        if (previousPageMatcher.matches()) {
            this.currentPage = Integer.parseInt(previousPageMatcher.group(1)) + 1;
        }
        if ((nextPageMatcher = StyledText.fromComponent(nextPageItem.method_7964()).getMatcher(this.personalStorageContainer.getNextItemPattern())).matches()) {
            this.currentPage = Integer.parseInt(nextPageMatcher.group(1)) - 1;
        }
        if (this.isItemIndicatingLastBankPage(nextPageItem)) {
            this.updateFinalPage();
        }
        WynntilsMod.postEvent(new BankPageSetEvent());
    }

    private boolean isItemIndicatingLastBankPage(class_1799 item) {
        return StyledText.fromComponent(item.method_7964()).endsWith(LAST_BANK_PAGE_STRING) || item.method_7964().getString().equals(FINAL_PAGE_NAME);
    }

    private void updateFinalPage() {
        switch (this.storageContainerType) {
            case ACCOUNT_BANK: {
                this.finalAccountBankPage.store(this.currentPage);
                break;
            }
            case BLOCK_BANK: {
                if (this.currentPage <= (Integer)this.finalBlockBankPage.get()) break;
                this.finalBlockBankPage.store(this.currentPage);
                break;
            }
            case BOOKSHELF: {
                this.finalBookshelfPage.store(this.currentPage);
                break;
            }
            case CHARACTER_BANK: {
                ((Map)this.finalCharacterBankPages.get()).put(Models.Character.getId(), this.currentPage);
                this.finalCharacterBankPages.touched();
                break;
            }
            case MISC_BUCKET: {
                this.finalMiscBucketPage.store(this.currentPage);
            }
        }
    }

    private Map<Integer, BankPageCustomization> getCurrentCustomizationMap() {
        return switch (this.storageContainerType) {
            default -> throw new MatchException(null, null);
            case PersonalStorageType.ACCOUNT_BANK -> (Map)this.customAccountBankPageCustomizations.get();
            case PersonalStorageType.BLOCK_BANK -> (Map)this.customBlockBankPageCustomizations.get();
            case PersonalStorageType.BOOKSHELF -> (Map)this.customBookshelfPageCustomizations.get();
            case PersonalStorageType.CHARACTER_BANK -> ((Map)this.customCharacterBankPagesCustomizations.get()).getOrDefault(Models.Character.getId(), new TreeMap());
            case PersonalStorageType.MISC_BUCKET -> (Map)this.customMiscBucketPageCustomizations.get();
        };
    }
}

