/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.containers;

import com.wynntils.core.components.Model;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.AbilityTreeContainer;
import com.wynntils.models.containers.containers.AbilityTreeResetContainer;
import com.wynntils.models.containers.containers.AspectsContainer;
import com.wynntils.models.containers.containers.BlacksmithContainer;
import com.wynntils.models.containers.containers.CharacterInfoContainer;
import com.wynntils.models.containers.containers.CharacterSelectionContainer;
import com.wynntils.models.containers.containers.ContentBookContainer;
import com.wynntils.models.containers.containers.CosmeticContainer;
import com.wynntils.models.containers.containers.CraftingStationContainer;
import com.wynntils.models.containers.containers.GuildBadgesContainer;
import com.wynntils.models.containers.containers.GuildBankContainer;
import com.wynntils.models.containers.containers.GuildLogContainer;
import com.wynntils.models.containers.containers.GuildManagementContainer;
import com.wynntils.models.containers.containers.GuildMemberListContainer;
import com.wynntils.models.containers.containers.GuildTerritoriesContainer;
import com.wynntils.models.containers.containers.HousingJukeboxContainer;
import com.wynntils.models.containers.containers.HousingListContainer;
import com.wynntils.models.containers.containers.IngredientPouchContainer;
import com.wynntils.models.containers.containers.InventoryContainer;
import com.wynntils.models.containers.containers.ItemIdentifierAugmentsContainer;
import com.wynntils.models.containers.containers.ItemIdentifierContainer;
import com.wynntils.models.containers.containers.JukeboxContainer;
import com.wynntils.models.containers.containers.LeaderboardRewardsContainer;
import com.wynntils.models.containers.containers.LobbyContainer;
import com.wynntils.models.containers.containers.LootrunRewardChestContainer;
import com.wynntils.models.containers.containers.PartyFinderMatchFoundContainer;
import com.wynntils.models.containers.containers.RaidRewardChestContainer;
import com.wynntils.models.containers.containers.RaidRewardPreviewContainer;
import com.wynntils.models.containers.containers.RaidStartContainer;
import com.wynntils.models.containers.containers.RatingRewardsContainer;
import com.wynntils.models.containers.containers.ScrapMenuContainer;
import com.wynntils.models.containers.containers.SeaskipperContainer;
import com.wynntils.models.containers.containers.StoreContainer;
import com.wynntils.models.containers.containers.personal.AccountBankContainer;
import com.wynntils.models.containers.containers.personal.BookshelfContainer;
import com.wynntils.models.containers.containers.personal.CharacterBankContainer;
import com.wynntils.models.containers.containers.personal.IslandBlockBankContainer;
import com.wynntils.models.containers.containers.personal.MiscBucketContainer;
import com.wynntils.models.containers.containers.personal.PersonalBlockBankContainer;
import com.wynntils.models.containers.containers.reward.ChallengeRewardContainer;
import com.wynntils.models.containers.containers.reward.DailyRewardContainer;
import com.wynntils.models.containers.containers.reward.EventContainer;
import com.wynntils.models.containers.containers.reward.FlyingChestContainer;
import com.wynntils.models.containers.containers.reward.IngredientBombRewardContainer;
import com.wynntils.models.containers.containers.reward.ItemBombRewardContainer;
import com.wynntils.models.containers.containers.reward.LootChestContainer;
import com.wynntils.models.containers.containers.reward.ObjectiveRewardContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketBuyContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketFiltersContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketOrderContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketSellContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketTradesContainer;
import com.wynntils.models.guild.type.GuildLogType;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.store.type.CosmeticItemType;
import com.wynntils.models.store.type.StoreItemType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ContainerModel
extends Model {
    public static final Pattern ABILITY_TREE_PATTERN = Pattern.compile("\udaff\udfea\ue000");
    public static final String CHARACTER_INFO_NAME = "\udaff\udfdc\ue003";
    public static final String STORE_MENU_NAME = "\udaff\udff4\ue02c\udaff\udf7c\uf027\udaff\udf52\udb00\udc3d.\udaff\udf22\udb00\udc40.\udaff\udf2f";
    public static final String GUILD_MENU_NAME = "[a-zA-Z\\s]+: Manage";
    public static final String GUILD_DIPLOMACY_MENU_NAME = "[a-zA-Z\\s]+: Diplomacy";
    public static final String MASTERY_TOMES_NAME = "\udaff\udfdb\ue005";
    private static final List<Container> containerTypes = new ArrayList<Container>();
    private Container currentContainer = null;

    public ContainerModel() {
        super(List.of());
        this.registerContainers();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScreenInit(ScreenInitEvent.Pre e) {
        class_437 class_4372 = e.getScreen();
        if (!(class_4372 instanceof class_465)) {
            return;
        }
        class_465 screen = (class_465)class_4372;
        this.currentContainer = null;
        for (Container container : containerTypes) {
            if (!container.isScreen((class_437)screen)) continue;
            this.currentContainer = container;
            this.currentContainer.setContainerId(screen.method_17577().field_7763);
            break;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScreenClose(ScreenClosedEvent.Post e) {
        this.currentContainer = null;
    }

    public Container getCurrentContainer() {
        return this.currentContainer;
    }

    private void registerContainers() {
        this.registerContainer(new AbilityTreeContainer());
        this.registerContainer(new AbilityTreeResetContainer());
        this.registerContainer(new AccountBankContainer());
        this.registerContainer(new AspectsContainer());
        this.registerContainer(new BlacksmithContainer());
        this.registerContainer(new BookshelfContainer());
        this.registerContainer(new ChallengeRewardContainer());
        this.registerContainer(new CharacterBankContainer());
        this.registerContainer(new CharacterInfoContainer());
        this.registerContainer(new CharacterSelectionContainer());
        this.registerContainer(new ContentBookContainer());
        this.registerContainer(new CosmeticContainer());
        this.registerContainer(new DailyRewardContainer());
        this.registerContainer(new EventContainer());
        this.registerContainer(new FlyingChestContainer());
        this.registerContainer(new GuildBadgesContainer());
        this.registerContainer(new GuildBankContainer());
        this.registerContainer(new GuildManagementContainer());
        this.registerContainer(new GuildMemberListContainer());
        this.registerContainer(new GuildTerritoriesContainer());
        this.registerContainer(new HousingJukeboxContainer());
        this.registerContainer(new HousingListContainer());
        this.registerContainer(new IngredientBombRewardContainer());
        this.registerContainer(new IngredientPouchContainer());
        this.registerContainer(new InventoryContainer());
        this.registerContainer(new IslandBlockBankContainer());
        this.registerContainer(new ItemBombRewardContainer());
        this.registerContainer(new ItemIdentifierAugmentsContainer());
        this.registerContainer(new ItemIdentifierContainer());
        this.registerContainer(new JukeboxContainer());
        this.registerContainer(new LeaderboardRewardsContainer());
        this.registerContainer(new LobbyContainer());
        this.registerContainer(new LootChestContainer());
        this.registerContainer(new LootrunRewardChestContainer());
        this.registerContainer(new MiscBucketContainer());
        this.registerContainer(new ObjectiveRewardContainer());
        this.registerContainer(new PartyFinderMatchFoundContainer());
        this.registerContainer(new PersonalBlockBankContainer());
        this.registerContainer(new RaidRewardChestContainer());
        this.registerContainer(new RaidRewardPreviewContainer());
        this.registerContainer(new RaidStartContainer());
        this.registerContainer(new RatingRewardsContainer());
        this.registerContainer(new ScrapMenuContainer());
        this.registerContainer(new SeaskipperContainer());
        this.registerContainer(new TradeMarketBuyContainer());
        this.registerContainer(new TradeMarketContainer());
        this.registerContainer(new TradeMarketFiltersContainer());
        this.registerContainer(new TradeMarketOrderContainer());
        this.registerContainer(new TradeMarketSellContainer());
        this.registerContainer(new TradeMarketTradesContainer());
        for (CosmeticItemType cosmeticItemType : CosmeticItemType.values()) {
            this.registerContainer(new CosmeticContainer(cosmeticItemType));
        }
        for (Enum enum_ : GuildLogType.values()) {
            this.registerContainer(new GuildLogContainer((GuildLogType)enum_));
        }
        for (ProfessionType type : ProfessionType.craftingProfessionTypes()) {
            this.registerContainer(new CraftingStationContainer(Pattern.compile(type.getDisplayName()), type));
        }
        for (StoreItemType storeItemType : StoreItemType.values()) {
            this.registerContainer(new StoreContainer(storeItemType));
        }
    }

    private void registerContainer(Container container) {
        containerTypes.add(container);
    }
}

