/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.containers.type;

import com.wynntils.utils.render.Texture;
import java.util.regex.Pattern;
import net.minecraft.class_437;

public enum LootChestTier {
    TIER_1(Texture.CHEST_T1, 1, Pattern.compile("Loot Chest \u00a77\\[\u00a7f\u272b\u00a78\u272b\u272b\u272b\u00a77\\]")),
    TIER_2(Texture.CHEST_T2, 2, Pattern.compile("Loot Chest \u00a7e\\[\u00a76\u272b\u272b\u00a78\u272b\u272b\u00a7e\\]")),
    TIER_3(Texture.CHEST_T3, 3, Pattern.compile("Loot Chest \u00a75\\[\u00a7d\u272b\u272b\u272b\u00a78\u272b\u00a75\\]")),
    TIER_4(Texture.CHEST_T4, 4, Pattern.compile("Loot Chest \u00a73\\[\u00a7b\u272b\u272b\u272b\u272b\u00a73\\]"));

    private final Texture waypointTexture;
    private final int waypointTier;
    private final Pattern titlePattern;

    private LootChestTier(Texture waypointTexture, int waypointTier, Pattern titlePattern) {
        this.waypointTexture = waypointTexture;
        this.waypointTier = waypointTier;
        this.titlePattern = titlePattern;
    }

    public Texture getWaypointTexture() {
        return this.waypointTexture;
    }

    public int getWaypointTier() {
        return this.waypointTier;
    }

    public String getWaypointName() {
        return "Loot Chest " + this.waypointTier;
    }

    public Pattern getTitlePattern() {
        return this.titlePattern;
    }

    public static LootChestTier fromTitle(class_437 screen) {
        for (LootChestTier chestType : LootChestTier.values()) {
            if (!chestType.getTitlePattern().matcher(screen.method_25440().getString()).matches()) continue;
            return chestType;
        }
        return null;
    }
}

