/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gambits;

import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.RaidStartContainer;
import com.wynntils.models.gambits.type.Gambit;
import com.wynntils.models.gambits.type.GambitStatus;
import com.wynntils.models.items.items.gui.GambitItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.neoforged.bus.api.SubscribeEvent;

public final class GambitModel
extends Model {
    private final List<Gambit> activeGambits = new ArrayList<Gambit>();

    public GambitModel() {
        super(List.of());
    }

    public List<Gambit> getActiveGambits() {
        return Collections.unmodifiableList(this.activeGambits);
    }

    @SubscribeEvent
    public void onContentSet(ContainerSetContentEvent.Pre event) {
        Container currentContainer = Models.Container.getCurrentContainer();
        if (currentContainer instanceof RaidStartContainer) {
            RaidStartContainer raidStartContainer = (RaidStartContainer)currentContainer;
            ArrayList<Integer> gambitSlots = new ArrayList<Integer>(raidStartContainer.getGambitSlots());
            boolean isFirst = true;
            for (Integer i : gambitSlots) {
                class_1799 itemStack = event.getItems().get(i);
                if (itemStack.method_7960()) continue;
                Optional<GambitItem> gambitItem = Models.Item.asWynnItem(itemStack, GambitItem.class);
                Gambit gambit = null;
                GambitStatus gambitStatus = null;
                if (gambitItem.isPresent()) {
                    gambit = gambitItem.get().getGambit();
                    gambitStatus = gambitItem.get().getGambitStatus();
                }
                if (gambit == null) continue;
                if (isFirst && gambitStatus != GambitStatus.PLAYER_READY) {
                    isFirst = false;
                    this.activeGambits.clear();
                }
                if (gambitStatus != GambitStatus.ENABLED) continue;
                this.activeGambits.add(gambit);
            }
        }
    }
}

