/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gear.type;

import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.SetInstance;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatType;
import java.util.List;
import java.util.Optional;

public record GearInstance(List<StatActualValue> identifications, List<Powder> powders, int rerolls, Optional<Float> overallQuality, Optional<ShinyStat> shinyStat, boolean meetsRequirements, Optional<SetInstance> setInstance) {
    public static GearInstance create(GearInfo gearInfo, List<StatActualValue> identifications, List<Powder> powders, int rerolls, Optional<ShinyStat> shinyStat, boolean meetsRequirements, Optional<SetInstance> setInstance) {
        return new GearInstance(identifications, powders, rerolls, StatCalculator.calculateOverallQuality(gearInfo.name(), gearInfo.getPossibleValueList(), identifications), shinyStat, meetsRequirements, setInstance);
    }

    public boolean hasOverallValue() {
        return this.overallQuality.isPresent();
    }

    public float getOverallPercentage() {
        return this.overallQuality.orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean isPerfect() {
        return this.overallQuality.orElse(Float.valueOf(0.0f)).floatValue() >= 100.0f;
    }

    public boolean isDefective() {
        return this.overallQuality.isPresent() && this.overallQuality.orElse(Float.valueOf(0.0f)).floatValue() <= 0.0f;
    }

    public StatActualValue getActualValue(StatType statType) {
        return this.identifications.stream().filter(s -> s.statType().equals(statType)).findFirst().orElse(null);
    }
}

