/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.inventory;

import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.models.inventory.InventoryWatcher;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.items.items.game.MaterialItem;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.neoforged.bus.api.SubscribeEvent;

public final class InventoryModel
extends Model {
    private static final int MAX_INVENTORY_SLOTS = 29;
    private static final List<String> AUTO_CASTER_MAJOR_IDS = List.of("Sorcery", "Madness");
    private final InventoryWatcher emptySlotWatcher = new InventoryWatcher(class_1799::method_7960);
    private final List<InventoryWatcher> watchers = new ArrayList<InventoryWatcher>(List.of(this.emptySlotWatcher));

    public InventoryModel() {
        super(List.of());
    }

    public CappedValue getInventorySlots() {
        return new CappedValue(29 - this.getEmptySlots(), 29);
    }

    public void registerWatcher(InventoryWatcher watcher) {
        this.watchers.add(watcher);
        this.updateCache();
    }

    public void unregisterWatcher(InventoryWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public List<class_1799> getEquippedItems() {
        ArrayList<class_1799> returnable = new ArrayList<class_1799>((Collection<class_1799>)McUtils.inventory().field_7548);
        Collections.reverse(returnable);
        for (int i : InventoryAccessory.getSlots()) {
            class_1799 accessory;
            int baseSize = 0;
            if (McUtils.player().method_45015()) {
                baseSize = McUtils.player().field_7512.method_7602().size();
            }
            if (ItemUtils.isEmptyAccessorySlot(accessory = McUtils.inventory().method_5438(i + baseSize))) continue;
            returnable.add(McUtils.inventory().method_5438(i + baseSize));
        }
        Optional<GearItem> handItemOpt = Models.Item.asWynnItem(McUtils.player().method_5998(class_1268.field_5808), GearItem.class);
        if (handItemOpt.isPresent() && handItemOpt.get().meetsActualRequirements() && handItemOpt.get().getGearType().isWeapon()) {
            returnable.add(McUtils.player().method_5998(class_1268.field_5808));
        }
        return returnable.stream().filter(itemStack -> !itemStack.method_7960()).toList();
    }

    public boolean hasAutoCasterItem() {
        for (class_1799 item : this.getEquippedItems()) {
            GearItem gearItem;
            Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(item, GearItem.class);
            if (gearItemOpt.isEmpty() || !(gearItem = gearItemOpt.get()).getItemInfo().fixedStats().majorIds().stream().anyMatch(majorId -> AUTO_CASTER_MAJOR_IDS.contains(majorId.name()))) continue;
            return true;
        }
        return Models.Raid.getRaidMajorIds(McUtils.mc().method_1548().method_1676()).stream().anyMatch(AUTO_CASTER_MAJOR_IDS::contains);
    }

    public int getAmountInInventory(String name) {
        int amount = 0;
        for (class_1799 itemStack : McUtils.inventory().field_7547) {
            StyledText itemName = StyledText.fromComponent(itemStack.method_7964()).getNormalized().trim();
            if (!itemName.getString().endsWith(name)) continue;
            amount += itemStack.method_7947();
        }
        return amount;
    }

    public int getIngredientAmountInInventory(String name) {
        return McUtils.inventory().field_7547.stream().filter(itemStack -> {
            Optional<IngredientItem> ingredientItem = Models.Item.asWynnItem((class_1799)itemStack, IngredientItem.class);
            if (ingredientItem.isEmpty()) {
                return false;
            }
            return ingredientItem.get().getName().startsWith(name);
        }).mapToInt(itemStack -> itemStack.field_8031).sum();
    }

    public int getMaterialsAmountInInventory(String name, int tier, boolean exact) {
        return McUtils.inventory().field_7547.stream().filter(itemStack -> {
            Optional<MaterialItem> materialItemOpt = Models.Item.asWynnItem((class_1799)itemStack, MaterialItem.class);
            if (materialItemOpt.isEmpty()) {
                return false;
            }
            MaterialItem materialItem = materialItemOpt.get();
            if (!itemStack.method_7964().getString().startsWith(name)) {
                return false;
            }
            return exact ? materialItem.getQualityTier() == tier : materialItem.getQualityTier() >= tier;
        }).mapToInt(itemStack -> itemStack.field_8031).sum();
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent e) {
        if (e.getNewState() == WorldState.WORLD) {
            this.updateCache();
        } else {
            this.resetCache();
        }
    }

    @SubscribeEvent
    public void onContainerSetEvent(ContainerSetContentEvent.Post e) {
        if (e.getContainerId() == McUtils.inventoryMenu().field_7763) {
            this.updateCache();
        }
    }

    @SubscribeEvent
    public void onSlotSetEvent(SetSlotEvent.Post e) {
        if (Objects.equals(e.getContainer(), McUtils.inventory())) {
            this.updateCache();
        }
    }

    private int getEmptySlots() {
        return this.emptySlotWatcher.getSlots();
    }

    private void updateCache() {
        class_1661 inventory = McUtils.inventory();
        this.watchers.forEach(watcher -> {
            int slots = 0;
            int totalCount = 0;
            for (class_1799 itemStack : inventory.field_7547) {
                if (!watcher.shouldInclude(itemStack)) continue;
                ++slots;
                totalCount += itemStack.method_7947();
            }
            if (slots != watcher.getSlots() || totalCount != watcher.getTotalCount()) {
                watcher.updateFromModel(slots, totalCount);
            }
        });
    }

    private void resetCache() {
        this.watchers.forEach(watcher -> watcher.updateFromModel(0, 0));
    }
}

