/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GameItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.gear.GearModel;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.items.items.game.GearItem;
import java.util.regex.Matcher;
import net.minecraft.class_1799;

public final class GearAnnotator
implements GameItemAnnotator {
    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher matcher = name.getMatcher(GearModel.GEAR_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        String itemName = matcher.group("name");
        GearInfo gearInfo = Models.Gear.getGearInfoFromDisplayName(itemName);
        if (gearInfo == null) {
            return null;
        }
        String unidRarity = matcher.group("unidrarity");
        if (unidRarity != null && !unidRarity.equals(gearInfo.tier().getChatFormatting().toString())) {
            return null;
        }
        String idRarity = matcher.group("idrarity");
        if (idRarity != null && !idRarity.equals(gearInfo.tier().getChatFormatting().toString())) {
            return null;
        }
        if (unidRarity == null && idRarity == null) {
            WynntilsMod.warn("GearAnnotator: No rarity information found in item name: " + String.valueOf(name));
            return null;
        }
        GearInstance gearInstance = matcher.group("unidentified") != null ? null : Models.Gear.parseInstance(gearInfo, itemStack);
        return new GearItem(gearInfo, gearInstance);
    }
}

