/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.handlers.item.ItemAnnotator;
import com.wynntils.models.items.items.game.MiscItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.LinkedList;
import net.minecraft.class_1799;

public final class MiscAnnotator
implements ItemAnnotator {
    private static final StyledText UNTRADABLE = StyledText.fromString("\u00a7cUntradable Item");
    private static final StyledText QUEST_ITEM = StyledText.fromString("\u00a7cQuest Item");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        if (lore.isEmpty()) {
            return null;
        }
        boolean untradable = false;
        boolean questItem = false;
        for (StyledText line : lore) {
            if (line.equals(UNTRADABLE)) {
                untradable = true;
            }
            if (!line.equals(QUEST_ITEM)) continue;
            questItem = true;
        }
        if (!untradable && !questItem) {
            return null;
        }
        return new MiscItem(name, untradable, questItem);
    }
}

