/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.models.items.items.gui.ActivityItem;
import com.wynntils.utils.colors.CustomColor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public final class ActivityAnnotator
implements GuiItemAnnotator {
    private static final Pattern ACTIVITY_PATTERN = Pattern.compile("^\u00a7(?<color>#.{8}|.)(?<name>.+) \u00a77\\[(?<type>.+)\\]$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        if (itemStack.method_7909() != class_1802.field_8574) {
            return null;
        }
        Matcher matcher = name.getMatcher(ACTIVITY_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        if (name.isEmpty()) {
            return null;
        }
        CustomColor color = name.getFirstPart().getPartStyle().getColor();
        ActivityType activityType = ActivityType.from(color, matcher.group("type"));
        if (activityType == null) {
            return null;
        }
        String activityName = matcher.group("name");
        ActivityInfo activityInfo = Models.Activity.parseItem(activityName, activityType, itemStack);
        if (activityInfo == null) {
            return null;
        }
        return new ActivityItem(activityInfo);
    }
}

