/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.models.items.encoding.data.IdentificationData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.RangedValue;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class IdentificationDataTransformer
extends DataTransformer<IdentificationData> {
    @Override
    public ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, IdentificationData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeIdentifications(data, data.extendedEncoding());
    }

    @Override
    protected boolean shouldEncodeData(ItemTransformingVersion version, IdentificationData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return data.extendedEncoding() ? !data.identifications().isEmpty() : data.identifications().stream().anyMatch(stat -> {
            StatPossibleValues possibleValues = data.possibleValues().get(stat.statType());
            return possibleValues == null || !possibleValues.isPreIdentified();
        });
    }

    @Override
    public ErrorOr<IdentificationData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeIdentifications(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.IDENTIFICATION_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodeIdentifications(IdentificationData data, boolean extendedEncoding) {
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        if (data.identifications().size() > 255) {
            WynntilsMod.warn("Item has more than 255 identifications!");
            return ErrorOr.error("Cannot encode more than 255 identifications!");
        }
        byte encodedSize = (byte)data.identifications().stream().filter(stat -> {
            StatPossibleValues possibleValues = data.possibleValues().get(stat.statType());
            return possibleValues == null || !possibleValues.isPreIdentified();
        }).count();
        bytes.add(UnsignedByte.of(encodedSize));
        bytes.add(UnsignedByte.of((byte)(extendedEncoding ? 1 : 0)));
        ErrorOr<List<UnsignedByte>> errorOrData = this.encodeIdentifications(data, bytes, extendedEncoding);
        if (errorOrData.hasError()) {
            return ErrorOr.error(errorOrData.getError());
        }
        return ErrorOr.of(bytes.toArray(new UnsignedByte[0]));
    }

    private ErrorOr<List<UnsignedByte>> encodeIdentifications(IdentificationData data, List<UnsignedByte> bytes, boolean encodeExtendedData) {
        if (encodeExtendedData) {
            List<StatActualValue> preIdentifiedStats = data.identifications().stream().filter(stat -> {
                StatPossibleValues possibleValues = data.possibleValues().get(stat.statType());
                return possibleValues != null && possibleValues.isPreIdentified();
            }).toList();
            bytes.add(UnsignedByte.of((byte)preIdentifiedStats.size()));
            for (StatActualValue identification : preIdentifiedStats) {
                StatPossibleValues possibleValues = data.possibleValues().get(identification.statType());
                Optional<Integer> idOpt = Models.Stat.getIdForStatType(identification.statType());
                if (idOpt.isEmpty()) {
                    WynntilsMod.warn("No ID found for stat type " + identification.statType().getApiName());
                    return ErrorOr.error("Unable to encode stat type: " + identification.statType().getDisplayName());
                }
                int id = idOpt.get();
                bytes.add(UnsignedByte.of((byte)id));
                int baseValue = possibleValues.baseValue();
                UnsignedByte[] baseValueBytes = UnsignedByteUtils.encodeVariableSizedInteger(baseValue);
                bytes.addAll(List.of(baseValueBytes));
            }
        }
        for (StatActualValue identification : data.identifications()) {
            UnsignedByte internalRollByte;
            int internalRoll;
            StatPossibleValues possibleValues = data.possibleValues().get(identification.statType());
            if (possibleValues == null) {
                WynntilsMod.warn("No possible values found for stat type " + identification.statType().getApiName());
                return ErrorOr.error("Unable to encode stat type, no possible values for id: " + identification.statType().getDisplayName());
            }
            if (possibleValues.isPreIdentified()) continue;
            Optional<Integer> idOpt = Models.Stat.getIdForStatType(identification.statType());
            if (idOpt.isEmpty()) {
                WynntilsMod.warn("No ID found for stat type " + identification.statType().getApiName());
                return ErrorOr.error("Unable to encode stat type: " + identification.statType().getDisplayName());
            }
            int id = idOpt.get();
            bytes.add(UnsignedByte.of((byte)id));
            if (encodeExtendedData) {
                int baseValue = possibleValues.baseValue();
                UnsignedByte[] baseValueBytes = UnsignedByteUtils.encodeVariableSizedInteger(baseValue);
                bytes.addAll(List.of(baseValueBytes));
            }
            if ((internalRoll = identification.internalRoll().low()) != (internalRollByte = UnsignedByte.of((byte)internalRoll)).value()) {
                WynntilsMod.warn("Internal roll " + internalRoll + " does not fit a byte!");
                return ErrorOr.error("Unable to encode stat type, invalid internal roll: " + identification.statType().getDisplayName());
            }
            bytes.add(internalRollByte);
        }
        return ErrorOr.of(bytes);
    }

    private ErrorOr<IdentificationData> decodeIdentifications(ArrayReader<UnsignedByte> byteReader) {
        ArrayList<StatActualValue> identifications = new ArrayList<StatActualValue>();
        ArrayList<StatPossibleValues> possibleValues = new ArrayList<StatPossibleValues>();
        HashMap<StatType, Integer> pendingCalculations = new HashMap<StatType, Integer>();
        short identificationCount = byteReader.read().value();
        boolean extendedData = byteReader.read().value() == 1;
        short preIdentifiedCount = 0;
        if (extendedData) {
            preIdentifiedCount = byteReader.read().value();
        }
        for (int i = 0; i < preIdentifiedCount + identificationCount; ++i) {
            boolean preIdentified;
            short id = byteReader.read().value();
            Optional<StatType> statTypeOpt = Models.Stat.getStatTypeForId(id);
            if (statTypeOpt.isEmpty()) {
                WynntilsMod.warn("No stat type found for id " + id);
                return ErrorOr.error("Unable to decode stat type for id: " + id);
            }
            StatType statType = statTypeOpt.get();
            boolean bl = preIdentified = i < preIdentifiedCount;
            if (extendedData) {
                int baseValue = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
                RangedValue range = StatCalculator.calculatePossibleValuesRange(baseValue, preIdentified, statType);
                StatPossibleValues possibleValue = new StatPossibleValues(statType, range, baseValue, preIdentified);
                possibleValues.add(possibleValue);
                if (preIdentified) continue;
            }
            short internalRoll = byteReader.read().value();
            pendingCalculations.put(statType, Integer.valueOf(internalRoll));
        }
        HashMap possibleValuesMap = possibleValues.stream().collect(HashMap::new, (map, value) -> map.put(value.statType(), value), HashMap::putAll);
        return ErrorOr.of(new IdentificationData(identifications, possibleValuesMap, extendedData, pendingCalculations));
    }
}

