/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.type;

import java.util.Arrays;
import java.util.List;

public enum TrialType {
    UNKNOWN("Unknown"),
    FAILED("Failed"),
    ALL_IN("All In"),
    GAMBLING_BEAST("Gambling Beast"),
    HUBRIS("Hubris"),
    LIGHTS_OUT("Lights Out"),
    SIDE_HUSTLE("Side Hustle"),
    TREASURY_BILL("Treasury Bill"),
    ULTIMATE_SACRIFICE("Ultimate Sacrifice"),
    WARMTH_DEVOURER("Warmth Devourer");

    private final String name;

    private TrialType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static TrialType fromName(String name) {
        for (TrialType type : TrialType.values()) {
            if (type == UNKNOWN || type == FAILED || !type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static List<TrialType> trialTypes() {
        return Arrays.stream(TrialType.values()).filter(type -> type != UNKNOWN && type != FAILED).toList();
    }
}

