/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.profession.type;

import com.wynntils.models.profession.type.ProfessionType;
import java.util.Locale;

public record ToolProfile(ToolType toolType, int tier) {
    public static ToolProfile fromString(String toolTypeName, int tier) {
        ToolType toolType = ToolType.fromString(toolTypeName);
        if (toolType == null) {
            return null;
        }
        return new ToolProfile(toolType, tier);
    }

    public int getLevel() {
        return this.tier == 1 ? 1 : 5 + (this.tier - 2) * 10;
    }

    @Override
    public String toString() {
        return "ToolProfile{toolType=" + String.valueOf((Object)this.toolType) + ", tier=" + this.tier + "}";
    }

    public static enum ToolType {
        PICKAXE(ProfessionType.MINING),
        AXE(ProfessionType.WOODCUTTING),
        SCYTHE(ProfessionType.FARMING),
        ROD(ProfessionType.FISHING);

        private final ProfessionType professionType;

        private ToolType(ProfessionType professionType) {
            this.professionType = professionType;
        }

        private static ToolType fromString(String str) {
            try {
                return ToolType.valueOf(str.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public ProfessionType getProfessionType() {
            return this.professionType;
        }
    }
}

