/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.raid.scoreboard;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.handlers.scoreboard.ScoreboardSegment;
import com.wynntils.handlers.scoreboard.type.SegmentMatcher;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RaidScoreboardPart
extends ScoreboardPart {
    private static final SegmentMatcher RAID_MATCHER = SegmentMatcher.fromPattern("Raid:");
    private static final Pattern BUFF_PATTERN = Pattern.compile("^Choose a buff or go$");
    private static final Pattern CHALLENGE_COMPLETED_PATTERN = Pattern.compile("^Challenge Completed!$");
    private static final Pattern CHALLENGES_PATTERN = Pattern.compile("^[-\u2014] Challenges: (\\d+)/(\\d+)$");
    private static final Pattern EXIT_PATTERN = Pattern.compile("^Go to the exit$");
    private static final Pattern PLAYERS_DIED_PATTERN = Pattern.compile("^Too many players have$");
    private static final Pattern OUT_OF_TIME_PATTERN = Pattern.compile("^You ran out of time!$");
    private static final Pattern TIMER_PATTERN = Pattern.compile("^[-\u2014] Time Left: (?<hours>\\d+:)?(?<minutes>\\d+):(?<seconds>\\d+)(?: \\[\\+\\d+[msMS]\\])?$");

    @Override
    public SegmentMatcher getSegmentMatcher() {
        return RAID_MATCHER;
    }

    @Override
    public void onSegmentChange(ScoreboardSegment newValue) {
        List<StyledText> content = newValue.getContent();
        if (content.isEmpty()) {
            WynntilsMod.warn("Raid scoreboard segment content is empty");
            return;
        }
        StyledText currentStateLine = content.getFirst();
        if (currentStateLine.matches(EXIT_PATTERN, StyleType.NONE)) {
            Models.Raid.tryEnterChallengeIntermission();
        } else if (currentStateLine.matches(CHALLENGE_COMPLETED_PATTERN, StyleType.NONE)) {
            Models.Raid.completeChallenge();
        } else if (currentStateLine.matches(BUFF_PATTERN, StyleType.NONE)) {
            Models.Raid.enterBuffRoom();
        } else if (currentStateLine.matches(PLAYERS_DIED_PATTERN, StyleType.NONE) || currentStateLine.matches(OUT_OF_TIME_PATTERN, StyleType.NONE)) {
            Models.Raid.failedRaid();
        } else {
            Models.Raid.tryStartChallenge(currentStateLine);
        }
        if (content.size() < 3) {
            WynntilsMod.warn("Raid scoreboard segment content is too short; less than 3");
            return;
        }
        for (StyledText line : content.subList(1, content.size())) {
            Matcher matcher = line.getMatcher(TIMER_PATTERN, StyleType.NONE);
            if (matcher.matches()) {
                int minutes = Integer.parseInt(matcher.group("minutes"));
                int seconds = Integer.parseInt(matcher.group("seconds"));
                if (matcher.group("hours") != null) {
                    int hours = Integer.parseInt(matcher.group("hours"));
                    minutes += hours * 60;
                }
                Models.Raid.setTimeLeft(minutes * 60 + seconds);
                continue;
            }
            matcher = line.getMatcher(CHALLENGES_PATTERN, StyleType.NONE);
            if (!matcher.matches()) continue;
            Models.Raid.setChallenges(new CappedValue(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))));
        }
    }

    @Override
    public void onSegmentRemove(ScoreboardSegment segment) {
    }

    @Override
    public void reset() {
    }

    @Override
    public String toString() {
        return "RaidScoreboardPart{}";
    }
}

