/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.stats.type;

import com.wynntils.models.stats.type.StatCalculationInfo;
import com.wynntils.models.stats.type.StatUnit;
import com.wynntils.utils.type.RangedValue;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class StatType {
    private static final List<RangedValue> STAR_INTERNAL_ROLL_RANGES = List.of(RangedValue.of(30, 100), RangedValue.of(101, 124), RangedValue.of(125, 129), RangedValue.of(130, 130));
    private final String key;
    private final String displayName;
    private final String apiName;
    private final String internalRollName;
    private final StatUnit unit;
    private final SpecialStatType specialStatType;

    protected StatType(String key, String displayName, String apiName, String internalRollName, StatUnit unit) {
        this.key = key;
        this.displayName = displayName;
        this.apiName = apiName;
        this.internalRollName = internalRollName;
        this.unit = unit;
        this.specialStatType = SpecialStatType.NONE;
    }

    protected StatType(String key, String displayName, String apiName, String internalRollName, StatUnit unit, SpecialStatType specialStatType) {
        this.key = key;
        this.displayName = displayName;
        this.apiName = apiName;
        this.internalRollName = internalRollName;
        this.unit = unit;
        this.specialStatType = specialStatType;
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getInternalRollName() {
        return this.internalRollName;
    }

    public StatUnit getUnit() {
        return this.unit;
    }

    public StatCalculationInfo getStatCalculationInfo(int baseValue) {
        boolean usePostiveRange;
        boolean bl = usePostiveRange = baseValue > 0;
        return usePostiveRange ? new StatCalculationInfo(RangedValue.of(30, 130), this.calculateAsInverted() ? RoundingMode.HALF_DOWN : RoundingMode.HALF_UP, Optional.of(1), Optional.empty(), this.treatAsInverted() ? List.of() : STAR_INTERNAL_ROLL_RANGES) : new StatCalculationInfo(RangedValue.of(70, 130), this.calculateAsInverted() ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN, Optional.empty(), Optional.of(-1), List.of());
    }

    public boolean displayAsInverted() {
        return false;
    }

    public boolean treatAsInverted() {
        return false;
    }

    public boolean calculateAsInverted() {
        return false;
    }

    public SpecialStatType getSpecialStatType() {
        return this.specialStatType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StatType that = (StatType)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.apiName, that.apiName) && Objects.equals(this.internalRollName, that.internalRollName) && this.unit == that.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.displayName, this.apiName, this.internalRollName, this.unit});
    }

    public String toString() {
        return "StatType[key=" + this.key + ", displayName=" + this.displayName + ", apiName=" + this.apiName + ", internalRollName=" + this.internalRollName + ", unit=" + String.valueOf((Object)this.unit) + "]";
    }

    public static enum SpecialStatType {
        NONE,
        TOME_BASE_STAT,
        CHARM_LEVELED_STAT;

    }
}

