/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.trademarket;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.mc.event.ChatSentEvent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.trademarket.TradeMarketBuyContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketFiltersContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketOrderContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketSellContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketTradesContainer;
import com.wynntils.models.containers.type.ContainerBounds;
import com.wynntils.models.trademarket.event.TradeMarketChatInputEvent;
import com.wynntils.models.trademarket.event.TradeMarketSellDialogueUpdatedEvent;
import com.wynntils.models.trademarket.event.TradeMarketStateEvent;
import com.wynntils.models.trademarket.type.TradeMarketPriceCheckInfo;
import com.wynntils.models.trademarket.type.TradeMarketPriceInfo;
import com.wynntils.models.trademarket.type.TradeMarketState;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.screens.trademarket.TradeMarketSearchResultHolder;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class TradeMarketModel
extends Model {
    private static final Set<TradeMarketState> CHAT_INPUT_STATES = EnumSet.of(TradeMarketState.SEARCH_CHAT_INPUT, TradeMarketState.AMOUNT_CHAT_INPUT, TradeMarketState.PRICE_CHAT_INPUT);
    private static final Pattern[] ITEM_NAME_PATTERNS = new Pattern[]{Pattern.compile("^\u00a76(?:Buying|Selling) [^ ]+ (.+?)(?:\u00a76)? for .+ Each$"), Pattern.compile("^\u00a76(?:Buying|Selling) [^ ]+ (.+)$"), Pattern.compile("^\u00a77\u00a7l[^ ]+x (.+)$")};
    private static final Pattern SEARCH_INPUT_PATTERN = Pattern.compile("^\u00a75(\ue00a\ue002|\ue001) Type the item name or type 'cancel' to cancel:$");
    private static final Pattern AMOUNT_INPUT_PATTERN = Pattern.compile("^\u00a75(\ue00a\ue002|\ue001) Type the amount you wish to (buy|sell) or type 'cancel' to cancel:$");
    private static final Pattern PRICE_INPUT_PATTERN = Pattern.compile("^\u00a75(\ue00a\ue002|\ue001) Type the price in emeralds or formatted \\(e\\.g '10eb', '10stx 5eb'\\) or type 'cancel' to cancel:$");
    private static final Pattern CANCELLED_PATTERN = Pattern.compile("^\u00a74(\ue008\ue002|\ue001) You moved and your chat input was canceled.$");
    private static final int TRADE_MARKET_PRICE_LINE = 1;
    private static final Pattern PRICE_STR = Pattern.compile("\u00a76Price:");
    public static final int TM_SELL_PRICE_SLOT = 28;
    private static final Pattern TM_SELL_PRICE_PATTERN = Pattern.compile("- \u00a77Per Unit:\u00a7f (\\d{1,3}(?:,\\d{3})*)");
    private static final StyledText TM_SELL_SET_PRICE_PATTERN = StyledText.fromString("\u00a7a\u00a7lSet Price");
    private static final int PRICE_CHECK_SLOT = 51;
    private static final Set<String> MISSING_PRICE_DATA = Set.of(" \u00a77Price data is only availableafter an item is added", " \u00a77There is no price informationabout this item at the moment");
    private static final Pattern PRICE_CHECK_BID_PATTERN = Pattern.compile("\u00a77Highest Buy Offer: \u00a7f([\\d,]+) \u00a78\\(.+\\)");
    private static final Pattern PRICE_CHECK_ASK_PATTERN = Pattern.compile("\u00a77Cheapest Sell Offer: \u00a7f([\\d,]+) \u00a78\\(.+\\)");
    private static final Pattern PRICE_CHECK_RECOMMENDED_PATTERN = Pattern.compile("\u00a7dRecommended Price:\u00a7f\\s*([\\d,]+) \u00a78\\(.+\\)");
    private static final Pattern PRICE_PATTERN = Pattern.compile("\u00a7[67] - (?:\u00a7f(?<amount>[\\d,]+) \u00a77x )?\u00a7(?:(?:(?:c\u2716|a\u2714) \u00a7f)|f\u00a7m|f)(?<price>[\\d,]+)\u00a77(?:\u00a7m)?\u00b2(?:\u00a7b \u272e (?<silverbullPrice>[\\d,]+)\u00a73\u00b2)?(?: .+)?");
    private static final Pattern SELL_ITEM_NAME_PATTERN = Pattern.compile("(.+)\u00c0");
    private static final String EMPTY_ITEM_SLOT = "Empty Item Slot";
    private static final int SELLABLE_ITEM_SLOT = 22;
    @Persisted
    private final Storage<Map<Integer, String>> presetFilters = new Storage(new TreeMap());
    private String lastSearchFilter = "";
    private static final ContainerBounds FILTER_SLOTS = new ContainerBounds(0, 0, 4, 2);
    private static final String NAME_FILTER = "Name Contains";
    private boolean filtersActive = false;
    private boolean nameFiltersActive = false;
    private TradeMarketState tradeMarketState = TradeMarketState.NOT_ACTIVE;
    private String soldItemName = null;

    public TradeMarketModel() {
        super(List.of());
        Handlers.Item.addSimplifiablePatterns(ITEM_NAME_PATTERNS);
        Handlers.WrappedScreen.registerWrappedScreen(new TradeMarketSearchResultHolder());
    }

    @SubscribeEvent
    public void onScreenOpen(ScreenOpenedEvent.Post event) {
        if (Models.Container.getCurrentContainer() instanceof TradeMarketFiltersContainer) {
            this.lastSearchFilter = "";
        }
        if (Models.Container.getCurrentContainer() != null) {
            this.updateStateFromContainer();
        }
    }

    @SubscribeEvent
    public void onScreenClose(ScreenClosedEvent.Post event) {
        if (this.inChatInput()) {
            return;
        }
        this.updateTradeMarketState(TradeMarketState.NOT_ACTIVE);
        this.filtersActive = false;
        this.nameFiltersActive = false;
    }

    @SubscribeEvent
    public void onFilterPageSetContent(ContainerSetContentEvent.Pre event) {
        if (this.tradeMarketState != TradeMarketState.FILTERS_PAGE) {
            return;
        }
        this.nameFiltersActive = false;
        this.filtersActive = false;
        FILTER_SLOTS.getSlots().forEach(slot -> {
            if (event.getItems().get((int)slot).method_7964().getString().equals(NAME_FILTER)) {
                this.nameFiltersActive = true;
            } else {
                this.filtersActive = this.filtersActive || !event.getItems().get((int)slot).method_7960();
            }
        });
    }

    @SubscribeEvent
    public void onSellDialogueUpdated(ContainerSetSlotEvent.Post e) {
        this.handleSellDialogueUpdate();
    }

    @SubscribeEvent
    public void onSellDialogueUpdated(ContainerSetContentEvent.Post e) {
        this.handleSellDialogueUpdate();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChatMessageReceive(ChatMessageEvent.Match event) {
        StyledText styledText = StyledTextUtils.unwrap(event.getMessage()).stripAlignment();
        TradeMarketState newState = styledText.matches(SEARCH_INPUT_PATTERN) ? TradeMarketState.SEARCH_CHAT_INPUT : (styledText.matches(AMOUNT_INPUT_PATTERN) ? TradeMarketState.AMOUNT_CHAT_INPUT : (styledText.matches(PRICE_INPUT_PATTERN) ? TradeMarketState.PRICE_CHAT_INPUT : (styledText.matches(CANCELLED_PATTERN) ? TradeMarketState.NOT_ACTIVE : null)));
        if (newState != null) {
            this.updateTradeMarketState(newState);
            if (this.inChatInput()) {
                TradeMarketChatInputEvent inputEvent = new TradeMarketChatInputEvent(newState, styledText);
                WynntilsMod.postEvent(inputEvent);
                if (inputEvent.isCanceled()) {
                    event.cancelChat();
                }
                if (inputEvent.getResponse() != null) {
                    McUtils.sendChat(inputEvent.getResponse());
                }
            }
        }
    }

    @SubscribeEvent
    public void onChatSent(ChatSentEvent event) {
        if (this.tradeMarketState != TradeMarketState.SEARCH_CHAT_INPUT) {
            return;
        }
        if (!this.nameFiltersActive && event.getMessage().equalsIgnoreCase("cancel")) {
            return;
        }
        if (!event.getMessage().isEmpty()) {
            this.nameFiltersActive = true;
        }
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent e) {
        this.updateTradeMarketState(TradeMarketState.NOT_ACTIVE);
        this.nameFiltersActive = false;
        this.filtersActive = false;
    }

    public boolean isFilterScreen(class_2561 component) {
        return false;
    }

    public String getLastSearchFilter() {
        return this.lastSearchFilter;
    }

    public void setLastSearchFilter(String lastSearchFilter) {
        this.lastSearchFilter = lastSearchFilter;
    }

    public Optional<String> getPresetFilter(int presetId) {
        return Optional.ofNullable((String)((Map)this.presetFilters.get()).get(presetId));
    }

    public void setPresetFilter(int presetId, String filter) {
        ((Map)this.presetFilters.get()).put(presetId, filter);
        this.presetFilters.touched();
    }

    public TradeMarketPriceInfo calculateItemPriceInfo(class_1799 itemStack) {
        LinkedList<StyledText> loreLines = LoreUtils.getLore(itemStack);
        StyledText priceLine = (StyledText)loreLines.get(1);
        if (priceLine == null || !priceLine.matches(PRICE_STR)) {
            WynntilsMod.warn("Trade Market item had an unexpected price line: " + String.valueOf(priceLine));
            return TradeMarketPriceInfo.EMPTY;
        }
        StyledText priceValueLine = (StyledText)loreLines.get(2);
        Matcher matcher = priceValueLine.getMatcher(PRICE_PATTERN);
        if (!matcher.matches()) {
            WynntilsMod.warn("Trade Market item had an unexpected price value line: " + String.valueOf(priceValueLine));
            return TradeMarketPriceInfo.EMPTY;
        }
        int price = Integer.parseInt(matcher.group("price").replace(",", ""));
        String silverbullPriceStr = matcher.group("silverbullPrice");
        int silverbullPrice = silverbullPriceStr == null ? price : Integer.parseInt(silverbullPriceStr.replace(",", ""));
        String amountStr = matcher.group("amount");
        int amount = amountStr == null ? 1 : Integer.parseInt(amountStr.replace(",", ""));
        return new TradeMarketPriceInfo(price, silverbullPrice, amount);
    }

    public int getUnitPrice() {
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_476)) {
            return -1;
        }
        class_476 cs = (class_476)class_4372;
        if (!(Models.Container.getCurrentContainer() instanceof TradeMarketSellContainer)) {
            return -1;
        }
        class_1799 priceCheckItem = (class_1799)((class_1707)cs.method_17577()).method_7602().get(28);
        if (priceCheckItem.method_7960()) {
            return -1;
        }
        String lore = LoreUtils.getStringLore(priceCheckItem).getString();
        Matcher priceCheckMatcher = TM_SELL_PRICE_PATTERN.matcher(lore);
        if (priceCheckMatcher.find()) {
            String priceCheckString = priceCheckMatcher.group(1);
            return Integer.parseInt(priceCheckString.replace(",", ""));
        }
        return -1;
    }

    public TradeMarketPriceCheckInfo getPriceCheckInfo() {
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_476)) {
            return TradeMarketPriceCheckInfo.EMPTY;
        }
        class_476 cs = (class_476)class_4372;
        if (!(Models.Container.getCurrentContainer() instanceof TradeMarketSellContainer)) {
            return TradeMarketPriceCheckInfo.EMPTY;
        }
        class_1799 priceCheckItem = (class_1799)((class_1707)cs.method_17577()).method_7602().get(51);
        if (priceCheckItem.method_7960()) {
            return TradeMarketPriceCheckInfo.EMPTY;
        }
        String lore = LoreUtils.getStringLore(priceCheckItem).getString();
        if (MISSING_PRICE_DATA.contains(lore)) {
            return TradeMarketPriceCheckInfo.EMPTY;
        }
        Matcher recommendedMatcher = PRICE_CHECK_RECOMMENDED_PATTERN.matcher(lore);
        int recommendedPrice = 0;
        if (recommendedMatcher.find()) {
            String priceCheckString = recommendedMatcher.group(1);
            recommendedPrice = Integer.parseInt(priceCheckString.replace(",", ""));
        } else {
            WynntilsMod.warn("Cannot find recommended price in price check item lore: " + lore);
        }
        Matcher bidMatcher = PRICE_CHECK_BID_PATTERN.matcher(lore);
        int bidPrice = -1;
        if (bidMatcher.find()) {
            String priceCheckString = bidMatcher.group(1);
            bidPrice = Integer.parseInt(priceCheckString.replace(",", ""));
        }
        Matcher askMatcher = PRICE_CHECK_ASK_PATTERN.matcher(lore);
        int askPrice = -1;
        if (askMatcher.find()) {
            String priceCheckString = askMatcher.group(1);
            askPrice = Integer.parseInt(priceCheckString.replace(",", ""));
        }
        return new TradeMarketPriceCheckInfo(recommendedPrice, bidPrice, askPrice);
    }

    public String getSoldItemName() {
        return this.soldItemName;
    }

    private void handleSellDialogueUpdate() {
        StyledText itemStackName;
        Matcher m;
        if (this.tradeMarketState != TradeMarketState.SELLING) {
            return;
        }
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_476)) {
            return;
        }
        class_476 cs = (class_476)class_4372;
        class_1799 itemStack = ((class_1707)cs.method_17577()).method_7611(22).method_7677();
        this.soldItemName = itemStack != class_1799.field_8037 ? ((m = (itemStackName = StyledText.fromComponent(itemStack.method_7964())).getMatcher(SELL_ITEM_NAME_PATTERN)).matches() && !m.group(1).contains(EMPTY_ITEM_SLOT) ? m.group(1) : null) : null;
        StyledText sellPriceItemName = StyledText.fromComponent(((class_1707)cs.method_17577()).method_7611(28).method_7677().method_7964());
        if (!sellPriceItemName.equals(TM_SELL_SET_PRICE_PATTERN)) {
            return;
        }
        WynntilsMod.postEvent(new TradeMarketSellDialogueUpdatedEvent());
    }

    private void updateStateFromContainer() {
        Container currentContainer = Models.Container.getCurrentContainer();
        TradeMarketState newState = currentContainer instanceof TradeMarketContainer ? (this.nameFiltersActive || this.filtersActive ? TradeMarketState.FILTERED_RESULTS : TradeMarketState.DEFAULT_RESULTS) : (currentContainer instanceof TradeMarketFiltersContainer ? TradeMarketState.FILTERS_PAGE : (currentContainer instanceof TradeMarketSellContainer ? TradeMarketState.SELLING : (currentContainer instanceof TradeMarketBuyContainer ? TradeMarketState.BUYING : (currentContainer instanceof TradeMarketTradesContainer ? TradeMarketState.VIEWING_TRADES : (currentContainer instanceof TradeMarketOrderContainer ? TradeMarketState.VIEWING_ORDER : null)))));
        if (newState != null) {
            this.updateTradeMarketState(newState);
        }
    }

    public boolean inChatInput() {
        return CHAT_INPUT_STATES.contains((Object)this.tradeMarketState);
    }

    public boolean inTradeMarket() {
        return this.tradeMarketState != TradeMarketState.NOT_ACTIVE;
    }

    public TradeMarketState getTradeMarketState() {
        return this.tradeMarketState;
    }

    private void updateTradeMarketState(TradeMarketState newState) {
        if (this.tradeMarketState != newState) {
            TradeMarketState oldState = this.tradeMarketState;
            this.tradeMarketState = newState;
            WynntilsMod.postEvent(new TradeMarketStateEvent(newState, oldState));
        }
    }
}

