/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.worlds;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.net.Download;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.profile.ServerProfile;
import com.wynntils.models.worlds.type.ServerRegion;
import com.wynntils.models.worlds.type.WorldState;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.neoforged.bus.api.SubscribeEvent;

public final class ServerListModel
extends Model {
    private static final int SERVER_UPDATE_MS = 15000;
    private static final List<String> SERVER_TYPES = List.of("lobby", "GM", "DEV", "WAR", "HB", "YT");
    private final ScheduledExecutorService timerExecutor = new ScheduledThreadPoolExecutor(1);
    private Map<String, ServerProfile> availableServers = new HashMap<String, ServerProfile>();

    public ServerListModel() {
        super(List.of());
        this.timerExecutor.scheduleWithFixedDelay(this::updateServerList, 0L, 15000L, TimeUnit.MILLISECONDS);
    }

    public List<String> getWynnServerTypes() {
        return Streams.concat((Stream[])new Stream[]{Arrays.stream(ServerRegion.values()).map(Enum::name), SERVER_TYPES.stream()}).toList();
    }

    public Set<String> getServers() {
        return this.availableServers.keySet();
    }

    public String getNewestServer() {
        return this.availableServers.entrySet().stream().max(Comparator.comparingLong(entry -> ((ServerProfile)entry.getValue()).getFirstSeen())).map(Map.Entry::getKey).orElse(null);
    }

    public List<String> getServersSortedOnUptime() {
        return this.availableServers.entrySet().stream().sorted(Comparator.comparingLong(entry -> -((ServerProfile)entry.getValue()).getFirstSeen())).map(Map.Entry::getKey).toList();
    }

    public List<String> getServersSortedOnNameOfType(String serverType) {
        return this.getServers().stream().filter(server -> server.startsWith(serverType)).sorted((o1, o2) -> {
            int number1 = Integer.parseInt(o1.substring(serverType.length()));
            int number2 = Integer.parseInt(o2.substring(serverType.length()));
            return number1 - number2;
        }).toList();
    }

    public ServerProfile getServer(String worldId) {
        return this.availableServers.get(worldId);
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() != WorldState.HUB && event.getNewState() != WorldState.CONNECTING) {
            return;
        }
        this.updateServerList();
    }

    private void updateServerList() {
        Download dl = Managers.Net.download(UrlId.DATA_ATHENA_SERVER_LIST);
        dl.handleJsonObject(json -> {
            JsonObject servers = json.getAsJsonObject("servers");
            HashMap<String, ServerProfile> newMap = new HashMap<String, ServerProfile>();
            long serverTime = dl.getResponseTimestamp();
            for (Map.Entry entry : servers.entrySet()) {
                JsonElement serverElement = (JsonElement)entry.getValue();
                if (!serverElement.isJsonObject()) {
                    WynntilsMod.warn("Server element is not a JsonObject: " + String.valueOf(serverElement));
                    continue;
                }
                serverElement.getAsJsonObject().addProperty("serverName", (String)entry.getKey());
                ServerProfile profile = (ServerProfile)WynntilsMod.GSON.fromJson((JsonElement)entry.getValue(), ServerProfile.class);
                profile.matchTime(serverTime);
                newMap.put((String)entry.getKey(), profile);
            }
            this.availableServers = newMap;
        });
    }
}

