/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.wynnfont;

import com.wynntils.core.components.Model;
import com.wynntils.core.text.FontLookup;
import com.wynntils.models.wynnfont.BackgroundEdge;
import com.wynntils.utils.colors.CustomColor;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;

public final class WynnFontModel
extends Model {
    private static final char NEGATIVE_SPACE = '\ue012';
    private static final char NEGATIVE_SPACE_EDGE = '\u2064';
    private static final char BACKGROUND = '\ue00f';
    private static final List<Character> normalCharacters = List.of(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('?'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\\'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));
    private static final List<Character> normalSpecialCharacters = List.of(Character.valueOf('!'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('='), Character.valueOf('>'));
    private static final List<Character> fancyCharacters = List.of(Character.valueOf('\ue040'), Character.valueOf('\ue041'), Character.valueOf('\ue042'), Character.valueOf('\ue043'), Character.valueOf('\ue044'), Character.valueOf('\ue045'), Character.valueOf('\ue046'), Character.valueOf('\ue047'), Character.valueOf('\ue048'), Character.valueOf('\ue049'), Character.valueOf('\ue04a'), Character.valueOf('\ue04b'), Character.valueOf('\ue04c'), Character.valueOf('\ue04d'), Character.valueOf('\ue04e'), Character.valueOf('\ue04f'), Character.valueOf('\ue050'), Character.valueOf('\ue051'), Character.valueOf('\ue052'), Character.valueOf('\ue053'), Character.valueOf('\ue054'), Character.valueOf('\ue055'), Character.valueOf('\ue056'), Character.valueOf('\ue057'), Character.valueOf('\ue058'), Character.valueOf('\ue059'), Character.valueOf('\ue05a'), Character.valueOf('\ue05b'), Character.valueOf('\ue05c'), Character.valueOf('\ue05d'), Character.valueOf('\ue05e'), Character.valueOf('\ue05f'), Character.valueOf('\ue060'), Character.valueOf('\ue061'), Character.valueOf('\ue062'), Character.valueOf('\ue063'), Character.valueOf('\ue064'), Character.valueOf('\ue065'), Character.valueOf('\ue066'), Character.valueOf('\ue067'), Character.valueOf('\ue068'), Character.valueOf('\ue069'));
    private static final List<Character> fancySpecialCharacters = List.of(Character.valueOf('\ue06a'), Character.valueOf('\ue06b'), Character.valueOf('\ue06c'), Character.valueOf('\ue06d'), Character.valueOf('\ue06e'), Character.valueOf('\ue06f'));
    private static final Map<Character, Character> normalToFancy = new HashMap<Character, Character>();
    private static final Map<Character, Character> normalToBackground = new HashMap<Character, Character>();

    public WynnFontModel() {
        super(List.of());
        this.createFontMaps();
        this.registerFontsForLookup();
    }

    public String toBackgroundFont(String text, CustomColor textColor, CustomColor backgroundColor, String leftEdge, String rightEdge) {
        StringBuilder sb = new StringBuilder();
        BackgroundEdge left = BackgroundEdge.fromString(leftEdge);
        BackgroundEdge right = BackgroundEdge.fromString(rightEdge);
        boolean inBackground = false;
        for (char c : text.toLowerCase(Locale.ROOT).toCharArray()) {
            if (c == ' ') {
                if (inBackground) {
                    sb.append("\u00a7").append(backgroundColor.toHexString()).append('\ue00f').append('\ue012').append(' ');
                    continue;
                }
                sb.append("\u00a7").append(textColor.toHexString()).append(' ');
                continue;
            }
            Character fancy = normalToBackground.get(Character.valueOf(c));
            if (fancy != null) {
                if (!inBackground) {
                    if (left != BackgroundEdge.NONE) {
                        sb.append("\u00a7").append(backgroundColor.toHexString()).append(left.getLeft()).append('\u2064');
                    }
                    inBackground = true;
                }
                sb.append("\u00a7").append(backgroundColor.toHexString()).append('\ue00f').append('\ue012');
                sb.append("\u00a7").append(textColor.toHexString()).append(fancy);
                continue;
            }
            if (inBackground) {
                if (right != BackgroundEdge.NONE) {
                    sb.append("\u00a7").append(backgroundColor.toHexString()).append('\u2064').append(right.getRight());
                }
                inBackground = false;
            }
            sb.append("\u00a7").append(textColor.toHexString()).append(c);
        }
        if (inBackground && right != BackgroundEdge.NONE) {
            sb.append("\u00a7").append(backgroundColor.toHexString()).append('\u2064').append(right.getRight());
        }
        return sb.toString();
    }

    public String toFancyFont(String text) {
        StringBuilder sb = new StringBuilder();
        for (char c : text.toLowerCase(Locale.ROOT).toCharArray()) {
            if (c == ' ') {
                sb.append(' ');
                continue;
            }
            Character fancy = normalToFancy.getOrDefault(Character.valueOf(c), Character.valueOf(c));
            sb.append(fancy);
        }
        return sb.toString();
    }

    private void createFontMaps() {
        int i;
        for (i = 0; i < fancyCharacters.size(); ++i) {
            normalToFancy.put(normalCharacters.get(i), fancyCharacters.get(i));
            normalToBackground.put(normalCharacters.get(i), fancyCharacters.get(i));
        }
        for (i = 0; i < fancySpecialCharacters.size(); ++i) {
            normalToFancy.put(normalSpecialCharacters.get(i), fancySpecialCharacters.get(i));
        }
    }

    private void registerWynnFont(String fontName, String code) {
        FontLookup.registerFontCode(class_2960.method_12829((String)fontName), code);
    }

    private void registerFontsForLookup() {
        this.registerWynnFont("minecraft:default", "d");
        this.registerWynnFont("minecraft:banner/pill", "bp");
        this.registerWynnFont("minecraft:chat/prefix", "cp");
        this.registerWynnFont("minecraft:hud/gameplay/default/top_left", "gtl");
        this.registerWynnFont("minecraft:hud/gameplay/default/top_middle", "gtm");
        this.registerWynnFont("minecraft:hud/gameplay/default/top_right", "gtr");
        this.registerWynnFont("minecraft:hud/gameplay/default/center_left", "gcl");
        this.registerWynnFont("minecraft:hud/gameplay/default/center_middle", "gcm");
        this.registerWynnFont("minecraft:hud/gameplay/default/center_right", "gcr");
        this.registerWynnFont("minecraft:hud/gameplay/default/bottom_left", "gbl");
        this.registerWynnFont("minecraft:hud/gameplay/default/bottom_middle", "gbm");
        this.registerWynnFont("minecraft:hud/gameplay/default/bottom_right", "gbr");
        this.registerWynnFont("minecraft:hud/selector/default/top_left", "stl");
        this.registerWynnFont("minecraft:hud/selector/default/top_middle", "stm");
        this.registerWynnFont("minecraft:hud/selector/default/top_right", "str");
        this.registerWynnFont("minecraft:hud/selector/default/center_left", "scl");
        this.registerWynnFont("minecraft:hud/selector/default/center_middle", "scm");
        this.registerWynnFont("minecraft:hud/selector/default/center_right", "scr");
        this.registerWynnFont("minecraft:hud/selector/default/bottom_left", "sbl");
        this.registerWynnFont("minecraft:hud/selector/default/bottom_middle", "sbm");
        this.registerWynnFont("minecraft:hud/selector/default/bottom_right", "sbr");
    }
}

