/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.AnimationPercentage;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ThrottledSupplier;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_355;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_640;
import net.minecraft.class_9779;
import net.neoforged.bus.api.SubscribeEvent;

public class CustomPlayerListOverlay
extends Overlay {
    private static final Comparator<class_640> PLAYER_INFO_COMPARATOR = Comparator.comparing(playerInfo -> playerInfo.method_2966().getName(), String::compareToIgnoreCase);
    private static final int DISTANCE_BETWEEN_CATEGORIES = 114;
    private static final int ROLL_WIDTH = 32;
    private static final int HALF_WIDTH = 233;
    private static final int WIDTH = 466;
    private static final int TOTAL_WIDTH = 530;
    private static final int MAX_WIDTH = 100;
    @Persisted
    private final Config<Integer> openingDuration = new Config<Integer>(125);
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.NORMAL);
    private final AnimationPercentage animationPercentage = new AnimationPercentage(() -> ((class_304)McUtils.options().field_1907).method_1434(), Duration.of(((Integer)this.openingDuration.get()).intValue(), ChronoUnit.MILLIS));
    private final ThrottledSupplier<List<StyledText>> availablePlayers = new ThrottledSupplier<List>(CustomPlayerListOverlay::getAvailablePlayers, Duration.ofMillis(250L));

    public CustomPlayerListOverlay() {
        super(new OverlayPosition(0.0f, 0.0f, VerticalAlignment.TOP, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.TOP_MIDDLE), 530.0f, Texture.PLAYER_LIST_OVERLAY.height());
    }

    @SubscribeEvent
    public void onRender(RenderEvent.Pre event) {
        if (event.getType() == RenderEvent.ElementType.PLAYER_TAB_LIST) {
            event.setCanceled(true);
        }
    }

    @Override
    protected boolean hideWhenNoGui() {
        return false;
    }

    @Override
    protected boolean isVisible() {
        return McUtils.options().field_1907.method_1434() || !this.animationPercentage.finishedClosingAnimation();
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        this.renderPlayerList(guiGraphics, this.animationPercentage.getAnimation());
    }

    @Override
    public void renderPreview(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        this.renderPlayerList(guiGraphics, 1.0);
    }

    private static List<StyledText> getAvailablePlayers() {
        class_355 defaultTabList = McUtils.mc().field_1705.method_1750();
        return McUtils.player().field_3944.method_45732().stream().sorted(PLAYER_INFO_COMPARATOR).limit(80L).map(arg_0 -> ((class_355)defaultTabList).method_1918(arg_0)).map(StyledText::fromComponent).map(StyledText::trim).map(StyledText::getString).map(styledText -> RenderedStringUtils.substringMaxWidth(styledText, 100)).map(StyledText::fromString).toList();
    }

    private void renderPlayerList(class_332 guiGraphics, double animation) {
        RenderSystem.disableDepthTest();
        class_4587 poseStack = guiGraphics.method_51448();
        if (animation < 1.0) {
            RenderUtils.enableScissor(guiGraphics, (int)((double)(this.getRenderX() + 32.0f + 233.0f) - 233.0 * animation), 0, (int)(466.0 * animation), McUtils.mc().method_22683().method_4507());
        }
        this.renderBackground(poseStack);
        this.renderPlayerNames(poseStack, this.availablePlayers.get());
        if (animation < 1.0) {
            RenderUtils.disableScissor(guiGraphics);
        }
        float middle = this.getRenderX() + 233.0f + 32.0f;
        this.renderRoll(poseStack, (float)((double)(middle - 32.0f + 11.0f) - 233.0 * animation), 0);
        this.renderRoll(poseStack, (float)((double)(middle - 11.0f) + 233.0 * animation), Texture.PLAYER_LIST_OVERLAY.width() - 32);
        RenderSystem.enableDepthTest();
    }

    private void renderRoll(class_4587 poseStack, float xPos, int uOffset) {
        RenderUtils.drawTexturedRect(poseStack, Texture.PLAYER_LIST_OVERLAY.resource(), xPos, this.getRenderY(), 0.0f, 32.0f, Texture.PLAYER_LIST_OVERLAY.height(), uOffset, 0, 32, Texture.PLAYER_LIST_OVERLAY.height(), Texture.PLAYER_LIST_OVERLAY.width(), Texture.PLAYER_LIST_OVERLAY.height());
    }

    private void renderPlayerNames(class_4587 poseStack, List<StyledText> players) {
        for (int i = 0; i < players.size(); ++i) {
            int x = i / 20;
            int y = i % 20;
            float xPos = this.getRenderX() + 32.0f + (float)(i % 20 == 0 ? 30 : 12) + (float)(114 * x);
            float yPos = i % 20 == 0 ? this.getRenderY() + 16.0f : this.getRenderY() + 18.0f + 14.0f + (float)(11 * (y - 1));
            FontRenderer.getInstance().renderText(poseStack, players.get(i), xPos, yPos, CustomColor.fromChatFormatting(class_124.field_1074), HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, (TextShadow)this.textShadow.get());
        }
    }

    private void renderBackground(class_4587 poseStack) {
        RenderUtils.drawTexturedRect(poseStack, Texture.PLAYER_LIST_OVERLAY.resource(), this.getRenderX() + 32.0f, this.getRenderY(), 0.0f, Texture.PLAYER_LIST_OVERLAY.width() - 32, Texture.PLAYER_LIST_OVERLAY.height(), 32, 0, Texture.PLAYER_LIST_OVERLAY.width() - 32, Texture.PLAYER_LIST_OVERLAY.height(), Texture.PLAYER_LIST_OVERLAY.width(), Texture.PLAYER_LIST_OVERLAY.height());
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.animationPercentage.setOpeningDuration(Duration.of(((Integer)this.openingDuration.get()).intValue(), ChronoUnit.MILLIS));
    }
}

