/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.gamebars;

import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.overlays.gamebars.BaseBarOverlay;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class OverflowableBarOverlay
extends BaseBarOverlay {
    protected OverflowableBarOverlay(OverlayPosition position, OverlaySize size, CustomColor textColor) {
        super(position, size, textColor);
    }

    @Override
    protected void renderBar(class_4587 poseStack, class_4597 bufferSource, float renderY, float renderHeight, float progress) {
        int textureY1 = this.getTextureY1();
        int textureY2 = this.getTextureY2();
        Texture texture = this.getTexture();
        if (Math.abs(progress) > 1.0f) {
            Texture overflowTexture = this.getOverflowTexture();
            float x1 = this.getRenderX();
            float x2 = this.getRenderX() + this.getWidth();
            int half = (textureY1 + textureY2) / 2 + (textureY2 - textureY1) % 2;
            BufferedRenderUtils.drawProgressBarBackground(poseStack, bufferSource, texture, x1, renderY, x2, renderY + renderHeight, 0, textureY1, 81, half);
            BufferedRenderUtils.drawProgressBarForeground(poseStack, bufferSource, texture, x1, renderY, x2, renderY + renderHeight, 0, half, 81, textureY2 + (textureY2 - textureY1) % 2, 1.0f);
            float overflowProgress = progress < 0.0f ? progress + 1.0f : progress - 1.0f;
            BufferedRenderUtils.drawProgressBarForeground(poseStack, bufferSource, overflowTexture, x1, renderY, x2, renderY + renderHeight, 0, half, 81, textureY2 + (textureY2 - textureY1) % 2, overflowProgress);
            return;
        }
        BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, texture, this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, textureY1, 81, textureY2, progress);
    }

    protected abstract Texture getTexture();

    protected abstract Texture getOverflowTexture();

    protected abstract int getTextureY1();

    protected abstract int getTextureY2();
}

