/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.ItemSearchHelperWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_7919;

public class ItemSearchWidget
extends SearchWidget {
    private final List<ItemProviderType> supportedProviderTypes;
    private final boolean supportsSorting;
    private final ItemSearchHelperWidget helperWidget;
    private ItemSearchQuery searchQuery;
    private final Consumer<ItemSearchQuery> onSearchQueryUpdateConsumer;

    public ItemSearchWidget(int x, int y, int width, int height, List<ItemProviderType> supportedProviderTypes, boolean supportsSorting, Consumer<ItemSearchQuery> onSearchQueryUpdateConsumer, TextboxScreen textboxScreen) {
        super(x, y, width, height, null, textboxScreen);
        this.supportedProviderTypes = supportedProviderTypes;
        this.helperWidget = new ItemSearchHelperWidget(x + width - 14, y + 6, Texture.INFO.width() / 3, Texture.INFO.height() / 3, Texture.INFO, true, supportedProviderTypes);
        this.supportsSorting = supportsSorting;
        this.onSearchQueryUpdateConsumer = onSearchQueryUpdateConsumer;
        this.searchQuery = Services.ItemFilter.createSearchQuery("", supportsSorting, supportedProviderTypes);
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        this.helperWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.helperWidget.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void renderText(class_4587 poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, class_327 font, int firstWidth, int highlightedWidth, int lastWidth, boolean defaultText) {
        if (defaultText || !this.getTextBoxInput().equals(this.searchQuery.queryString())) {
            super.renderText(poseStack, renderedText, renderedTextStart, firstPortion, highlightedPortion, lastPortion, font, firstWidth, highlightedWidth, lastWidth, defaultText);
            return;
        }
        int charIndex = renderedTextStart;
        StyledText firstPortionStyled = StyledText.EMPTY;
        for (char c : firstPortion.toCharArray()) {
            firstPortionStyled = firstPortionStyled.append(this.getStyledText(charIndex++, c));
        }
        StyledText highlightedPortionStyled = StyledText.EMPTY;
        for (char c : highlightedPortion.toCharArray()) {
            highlightedPortionStyled = highlightedPortionStyled.append(this.getStyledText(charIndex++, c));
        }
        StyledText lastPortionStyled = StyledText.EMPTY;
        for (char c : lastPortion.toCharArray()) {
            lastPortionStyled = lastPortionStyled.append(this.getStyledText(charIndex++, c));
        }
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, firstPortionStyled, (float)(this.method_46426() + this.textPadding), (float)(this.method_46426() + this.field_22758 - this.textPadding - lastWidth - highlightedWidth), (float)this.method_46427() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        FontRenderer.getInstance().renderAlignedHighlightedTextInBox(poseStack, highlightedPortionStyled, this.method_46426() + this.textPadding + firstWidth, this.method_46426() + this.field_22758 - this.textPadding - lastWidth, (float)this.method_46427() + 6.5f, (float)this.method_46427() + 6.5f, 0.0f, CommonColors.BLUE, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, lastPortionStyled, (float)(this.method_46426() + this.textPadding + firstWidth + highlightedWidth), (float)(this.method_46426() + this.field_22758 - this.textPadding), (float)this.method_46427() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        this.drawCursor(poseStack, this.method_46426() + font.method_1727(renderedText.substring(0, Math.min(this.cursorPosition, renderedText.length()))) + this.textPadding - 2, (float)this.method_46427() + 6.5f, VerticalAlignment.TOP, false);
    }

    private StyledText getStyledText(int charIndex, char c) {
        for (Pair<class_124, Pair<Integer, Integer>> colorRange : this.searchQuery.colorRanges()) {
            if (charIndex < colorRange.value().key() || charIndex >= colorRange.value().value()) continue;
            return StyledText.fromString(String.valueOf(colorRange.key()) + String.valueOf(c));
        }
        return StyledText.fromString(String.valueOf(c));
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.helperWidget.method_46421(x + this.field_22758 - 14);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.helperWidget.method_46419(y + 6);
    }

    @Override
    protected int getMaxTextWidth() {
        return this.field_22758 - 22;
    }

    @Override
    protected void onUpdate(String text) {
        this.searchQuery = Services.ItemFilter.createSearchQuery(text, this.supportsSorting, this.supportedProviderTypes);
        this.onSearchQueryUpdateConsumer.accept(this.searchQuery);
        if (this.searchQuery.errors().isEmpty()) {
            this.method_47400(null);
        } else {
            this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)String.join((CharSequence)"\n\n", this.searchQuery.errors())).method_27692(class_124.field_1061)));
        }
    }

    public ItemSearchQuery getSearchQuery() {
        return this.searchQuery;
    }
}

