/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class TextInputBoxWidget
extends class_339 {
    private static final class_2561 DEFAULT_TEXT = class_2561.method_43471((String)"screens.wynntils.textInputWidget.defaultText");
    private static final int CURSOR_PADDING = 3;
    private static final int CURSOR_TICK = 350;
    private final Consumer<String> onUpdateConsumer;
    protected List<class_2561> tooltip;
    protected String textBoxInput = "";
    protected int cursorPosition = 0;
    private int highlightPosition = 0;
    private long lastCursorSwitch = 0L;
    private boolean renderCursor = true;
    private CustomColor renderColor = CommonColors.WHITE;
    protected boolean isDragging = false;
    protected final TextboxScreen textboxScreen;
    protected int textPadding = 2;

    protected TextInputBoxWidget(int x, int y, int width, int height, class_2561 boxTitle, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
        super(x, y, width, height, boxTitle);
        this.onUpdateConsumer = onUpdateConsumer == null ? this::onUpdate : onUpdateConsumer;
        this.textboxScreen = textboxScreen;
    }

    public TextInputBoxWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen, TextInputBoxWidget oldWidget) {
        this(x, y, width, height, (class_2561)class_2561.method_43473(), onUpdateConsumer, textboxScreen);
        if (oldWidget != null) {
            this.textBoxInput = oldWidget.textBoxInput;
            this.setCursorAndHighlightPositions(oldWidget.cursorPosition);
            this.renderColor = oldWidget.renderColor;
        }
    }

    public TextInputBoxWidget(int x, int y, int width, int height, Consumer<String> onUpdateConsumer, TextboxScreen textboxScreen) {
        this(x, y, width, height, onUpdateConsumer, textboxScreen, null);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        Pair<String, Integer> renderedTextDetails = this.getRenderedText(this.getMaxTextWidth());
        String renderedText = renderedTextDetails.a();
        int renderedTextStart = renderedTextDetails.b();
        Pair<Integer, Integer> highlightedVisibleInterval = this.getRenderedHighlighedInterval(renderedText);
        int startIndex = highlightedVisibleInterval.a();
        int endIndex = highlightedVisibleInterval.b();
        String firstPortion = renderedText.substring(0, startIndex);
        String highlightedPortion = renderedText.substring(startIndex, endIndex);
        String lastPortion = renderedText.substring(endIndex);
        class_327 font = FontRenderer.getInstance().getFont();
        int firstWidth = font.method_1727(firstPortion);
        int highlightedWidth = font.method_1727(highlightedPortion);
        int lastWidth = font.method_1727(lastPortion);
        this.doRenderWidget(poseStack, renderedText, renderedTextStart, firstPortion, highlightedPortion, lastPortion, font, firstWidth, highlightedWidth, lastWidth);
    }

    protected void doRenderWidget(class_4587 poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, class_327 font, int firstWidth, int highlightedWidth, int lastWidth) {
        poseStack.method_22903();
        poseStack.method_46416((float)this.method_46426(), (float)this.method_46427(), 0.0f);
        RenderUtils.drawRect(poseStack, CommonColors.BLACK, 0.0f, 0.0f, 0.0f, this.field_22758, this.field_22759);
        RenderUtils.drawRectBorders(poseStack, this.field_22762 ? CommonColors.LIGHT_GRAY : CommonColors.GRAY, 0.0f, 0.0f, this.field_22758, this.field_22759, 1.0f, 2.0f);
        boolean defaultText = Objects.equals(this.textBoxInput, "");
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(defaultText ? DEFAULT_TEXT.getString() : firstPortion), this.textPadding, this.field_22758 - lastWidth - highlightedWidth, this.textPadding, this.field_22759 - this.textPadding, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : this.renderColor, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (!defaultText) {
            FontRenderer.getInstance().renderAlignedHighlightedTextInBox(poseStack, StyledText.fromString(highlightedPortion), this.textPadding + firstWidth, this.field_22758 - lastWidth, this.textPadding, this.field_22759 - this.textPadding, 0.0f, CommonColors.BLUE, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(lastPortion), this.textPadding + firstWidth + highlightedWidth, this.field_22758, this.textPadding, this.field_22759 - this.textPadding, 0.0f, this.renderColor, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
        this.drawCursor(poseStack, font.method_1727(renderedText.substring(0, Math.min(this.cursorPosition, renderedText.length()))), (this.textPadding + this.field_22759 - this.textPadding) / 2, VerticalAlignment.MIDDLE, false);
        if (this.field_22762 && this.tooltip != null) {
            McUtils.screen().method_47414(Lists.transform(this.tooltip, class_2561::method_30937));
        }
        poseStack.method_22909();
    }

    protected int getMaxTextWidth() {
        return this.field_22758 - 8;
    }

    private Pair<String, Integer> getRenderedText(float maxTextWidth) {
        class_327 font = FontRenderer.getInstance().getFont();
        if ((float)font.method_1727(this.textBoxInput) < maxTextWidth) {
            return Pair.of(this.textBoxInput, 0);
        }
        StringBuilder builder = new StringBuilder();
        int stringPosition = this.cursorPosition;
        while ((float)font.method_1727(builder.toString()) < maxTextWidth && stringPosition > 0) {
            builder.append(this.textBoxInput.charAt(--stringPosition));
        }
        int startingAt = stringPosition;
        builder.reverse();
        for (stringPosition = this.cursorPosition; (float)font.method_1727(builder.toString()) < maxTextWidth && stringPosition < this.textBoxInput.length(); ++stringPosition) {
            builder.append(this.textBoxInput.charAt(stringPosition));
        }
        return Pair.of(builder.toString(), startingAt);
    }

    private Pair<Integer, Integer> getRenderedHighlighedInterval(String renderedText) {
        if (renderedText.isEmpty()) {
            return Pair.of(0, 0);
        }
        int length = renderedText.length();
        int highlightedStart = Math.min(this.cursorPosition, this.highlightPosition);
        int highlightedEnd = Math.max(this.cursorPosition, this.highlightPosition);
        Pair<Integer, Integer> renderedInterval = Pair.of(0, length);
        Pair<Integer, Integer> highlightedInterval = Pair.of(highlightedStart, highlightedEnd);
        int a = 0;
        int b = 0;
        if (highlightedInterval.a() <= renderedInterval.b() && renderedInterval.a() <= highlightedInterval.b()) {
            a = Math.max(renderedInterval.a(), highlightedInterval.a());
            b = Math.min(renderedInterval.b(), highlightedInterval.b());
        }
        a = class_3532.method_15340((int)a, (int)0, (int)length);
        b = class_3532.method_15340((int)b, (int)0, (int)length);
        return Pair.of(a, b);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22762) {
            McUtils.playSoundUI((class_3414)class_3417.field_15015.comp_349());
            if (button == 1) {
                this.setTextBoxInput("");
                this.setCursorAndHighlightPositions(0);
            } else {
                this.setCursorAndHighlightPositions(this.getIndexAtPosition(mouseX));
            }
            this.isDragging = true;
            this.textboxScreen.setFocusedTextInput(this);
            this.method_25365(true);
            return true;
        }
        if (this.method_25370()) {
            McUtils.playSoundUI((class_3414)class_3417.field_15015.comp_349());
            this.setCursorAndHighlightPositions(this.cursorPosition);
            this.method_25365(false);
            this.textboxScreen.setFocusedTextInput(null);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging) {
            this.setCursorPosition(this.getIndexAtPosition(mouseX));
        }
        return true;
    }

    protected int getIndexAtPosition(double mouseX) {
        float width;
        double distance;
        mouseX -= (double)this.method_46426();
        mouseX -= (double)this.textPadding;
        Pair<String, Integer> renderedTextDetails = this.getRenderedText(this.getMaxTextWidth());
        String renderedText = renderedTextDetails.a();
        int shift = renderedTextDetails.b();
        class_327 font = FontRenderer.getInstance().getFont();
        if ((double)font.method_1727(renderedText) < mouseX) {
            return renderedText.length() + shift;
        }
        int closestWidthCharIndex = 0;
        double closestDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < renderedText.length() && !((distance = Math.abs(mouseX - (double)(width = (float)font.method_1727(renderedText.substring(0, i))))) > closestDistance)) {
            closestDistance = distance;
            closestWidthCharIndex = i++;
        }
        return closestWidthCharIndex + shift;
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.method_25370()) {
            return false;
        }
        if (this.textBoxInput == null) {
            this.textBoxInput = "";
        }
        if (this.hasHighlighted()) {
            this.replaceHighlighted(String.valueOf(codePoint));
        } else {
            this.textBoxInput = this.textBoxInput.substring(0, this.cursorPosition) + codePoint + this.textBoxInput.substring(this.cursorPosition);
            this.setCursorPosition(this.cursorPosition + 1);
            this.setHighlightPosition(this.cursorPosition);
        }
        this.onUpdateConsumer.accept(this.getTextBoxInput());
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.removeFocus();
            return true;
        }
        class_309 keyboardHandler = class_310.method_1551().field_1774;
        if (class_437.method_25438((int)keyCode)) {
            keyboardHandler.method_1455(this.hasHighlighted() ? this.getHighlightedText() : this.getTextBoxInput());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.hasHighlighted()) {
                this.replaceHighlighted(keyboardHandler.method_1460());
            } else {
                this.setTextBoxInput(this.textBoxInput.substring(0, this.cursorPosition) + keyboardHandler.method_1460() + this.textBoxInput.substring(this.cursorPosition));
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            if (this.hasHighlighted()) {
                keyboardHandler.method_1455(this.getHighlightedText());
                this.replaceHighlighted("");
            } else {
                keyboardHandler.method_1455(this.getTextBoxInput());
                this.setTextBoxInput("");
            }
            return true;
        }
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorPosition(this.textBoxInput.length());
            this.setHighlightPosition(0);
            return true;
        }
        if (keyCode == 259) {
            if (this.textBoxInput.isEmpty()) {
                return true;
            }
            if (this.hasHighlighted()) {
                this.replaceHighlighted("");
                return true;
            }
            if (class_437.method_25441()) {
                this.setTextBoxInput(this.textBoxInput.substring(this.cursorPosition));
                this.setCursorAndHighlightPositions(0);
                return true;
            }
            this.textBoxInput = this.textBoxInput.substring(0, Math.max(0, this.cursorPosition - 1)) + this.textBoxInput.substring(this.cursorPosition);
            this.setCursorAndHighlightPositions(this.cursorPosition - 1);
            this.onUpdateConsumer.accept(this.getTextBoxInput());
            return true;
        }
        if (keyCode == 261) {
            if (this.textBoxInput.isEmpty()) {
                return true;
            }
            if (this.hasHighlighted()) {
                this.replaceHighlighted("");
                return true;
            }
            if (class_437.method_25441()) {
                this.setTextBoxInput(this.textBoxInput.substring(0, this.cursorPosition));
                return true;
            }
            this.textBoxInput = this.textBoxInput.substring(0, this.cursorPosition) + this.textBoxInput.substring(Math.min(this.textBoxInput.length(), this.cursorPosition + 1));
            this.onUpdateConsumer.accept(this.getTextBoxInput());
            return true;
        }
        if (keyCode == 263) {
            if (this.hasHighlighted() && !class_437.method_25442() && !class_437.method_25441()) {
                this.setCursorAndHighlightPositions(Math.min(this.cursorPosition, this.highlightPosition));
                return true;
            }
            if (class_437.method_25441() && class_437.method_25442()) {
                this.setCursorPosition(0);
                return true;
            }
            if (class_437.method_25441()) {
                this.setCursorAndHighlightPositions(0);
                return true;
            }
            if (class_437.method_25442()) {
                this.setCursorPosition(this.cursorPosition - 1);
                return true;
            }
            if (this.hasHighlighted()) {
                this.setCursorAndHighlightPositions(Math.min(this.cursorPosition, this.highlightPosition));
                return true;
            }
            this.setCursorAndHighlightPositions(this.cursorPosition - 1);
            return true;
        }
        if (keyCode == 262) {
            if (class_437.method_25441() && class_437.method_25442()) {
                this.setCursorPosition(this.textBoxInput.length());
                return true;
            }
            if (class_437.method_25441()) {
                this.setCursorAndHighlightPositions(this.textBoxInput.length());
                return true;
            }
            if (class_437.method_25442()) {
                this.setCursorPosition(this.cursorPosition + 1);
                return true;
            }
            if (this.hasHighlighted()) {
                this.setCursorAndHighlightPositions(Math.max(this.cursorPosition, this.highlightPosition));
                return true;
            }
            this.setCursorAndHighlightPositions(this.cursorPosition + 1);
            return true;
        }
        if (keyCode == 268) {
            this.setCursorAndHighlightPositions(0);
            return true;
        }
        if (keyCode == 269) {
            this.setCursorAndHighlightPositions(this.textBoxInput.length());
            return true;
        }
        return true;
    }

    public boolean method_25370() {
        return this.textboxScreen.getFocusedTextInput() == this;
    }

    public void method_47399(class_6382 narrationElementOutput) {
    }

    public void setTextBoxInput(String textBoxInput) {
        this.textBoxInput = textBoxInput;
        this.setCursorAndHighlightPositions(textBoxInput.length());
        this.onUpdateConsumer.accept(this.textBoxInput);
    }

    public void resetTextBoxInput() {
        this.textBoxInput = "";
        this.setCursorAndHighlightPositions(0);
    }

    protected void drawCursor(class_4587 poseStack, float x, float y, VerticalAlignment verticalAlignment, boolean forceUnfocusedCursor) {
        if (this.isDragging || this.hasHighlighted()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastCursorSwitch > 350L) {
            this.renderCursor = !this.renderCursor;
            this.lastCursorSwitch = System.currentTimeMillis();
        }
        if (!this.renderCursor) {
            return;
        }
        if (this.method_25370() || forceUnfocusedCursor) {
            class_327 font = FontRenderer.getInstance().getFont();
            float cursorRenderY = switch (verticalAlignment) {
                default -> throw new MatchException(null, null);
                case VerticalAlignment.TOP -> y - 2.0f;
                case VerticalAlignment.MIDDLE -> {
                    Objects.requireNonNull(font);
                    yield y - 9.0f + 2.0f;
                }
                case VerticalAlignment.BOTTOM -> {
                    Objects.requireNonNull(font);
                    yield y - 9.0f - 2.0f;
                }
            };
            Objects.requireNonNull(font);
            RenderUtils.drawRect(poseStack, CommonColors.WHITE, x + 1.0f, cursorRenderY, 0.0f, 1.0f, 9 + 3);
        }
    }

    protected void removeFocus() {
        this.textboxScreen.setFocusedTextInput(null);
    }

    protected void setCursorPosition(int cursorPosition) {
        this.cursorPosition = MathUtils.clamp(cursorPosition, 0, this.textBoxInput.length());
    }

    protected void setCursorAndHighlightPositions(int pos) {
        this.highlightPosition = this.cursorPosition = MathUtils.clamp(pos, 0, this.textBoxInput.length());
    }

    public String getTextBoxInput() {
        return this.textBoxInput;
    }

    private String getHighlightedText() {
        int startIndex = Math.min(this.cursorPosition, this.highlightPosition);
        int endIndex = Math.max(this.cursorPosition, this.highlightPosition);
        return this.textBoxInput.substring(startIndex, endIndex);
    }

    public void setRenderColor(CustomColor renderColor) {
        this.renderColor = renderColor;
    }

    private boolean hasHighlighted() {
        return this.cursorPosition != this.highlightPosition;
    }

    protected void setHighlightPosition(int position) {
        int length = this.textBoxInput.length();
        this.highlightPosition = class_3532.method_15340((int)position, (int)0, (int)length);
    }

    private void replaceHighlighted(String text) {
        int startIndex = Math.min(this.cursorPosition, this.highlightPosition);
        int endIndex = Math.max(this.cursorPosition, this.highlightPosition);
        int insertLength = text.length();
        this.textBoxInput = new StringBuilder(this.textBoxInput).replace(startIndex, endIndex, text).toString();
        this.setCursorPosition(startIndex + insertLength);
        this.setHighlightPosition(this.cursorPosition);
        this.onUpdateConsumer.accept(this.textBoxInput);
    }

    protected void onUpdate(String text) {
    }
}

