/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.colorpicker.widgets;

import com.wynntils.screens.colorpicker.ColorPickerScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;

public class SaturationBrightnessWidget
extends class_339 {
    private final ColorPickerScreen colorPickerScreen;
    private boolean cursorHeld = false;
    private CustomColor color;
    private int cursorX;
    private int cursorY;

    public SaturationBrightnessWidget(int x, int y, int width, int height, ColorPickerScreen colorPickerScreen, CustomColor baseColor) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Saturation Brightness Widget"));
        this.colorPickerScreen = colorPickerScreen;
        float[] hsbColor = baseColor.asHSB();
        this.color = CustomColor.fromHSV(hsbColor[0], 1.0f, 1.0f, 1.0f);
        this.cursorX = (int)class_3532.method_15363((float)((float)width * hsbColor[1]), (float)0.0f, (float)width);
        this.cursorY = (int)class_3532.method_15363((float)((float)height * (1.0f - hsbColor[2])), (float)0.0f, (float)height);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.fillSidewaysGradient(guiGraphics.method_51448(), this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0, CommonColors.WHITE, this.color.withAlpha(255));
        RenderUtils.fillGradient(guiGraphics.method_51448(), this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0, CommonColors.WHITE.withAlpha(0), CommonColors.BLACK);
        RenderUtils.drawRectBorders(guiGraphics.method_51448(), CommonColors.BLACK, this.method_46426() + this.cursorX - 2, this.method_46427() + this.cursorY - 2, this.method_46426() + this.cursorX + 2, this.method_46427() + this.cursorY + 2, 2.0f, 1.0f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        this.cursorX = (int)(mouseX - (double)this.method_46426());
        this.cursorY = (int)(mouseY - (double)this.method_46427());
        this.cursorHeld = true;
        this.updateValue(this.cursorX, this.cursorY);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.cursorHeld) {
            return false;
        }
        this.cursorX = class_3532.method_15340((int)((int)(mouseX - (double)this.method_46426())), (int)0, (int)this.method_25368());
        this.cursorY = class_3532.method_15340((int)((int)(mouseY - (double)this.method_46427())), (int)0, (int)this.method_25364());
        this.updateValue(this.cursorX, this.cursorY);
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.cursorHeld = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public void setColor(CustomColor color) {
        this.color = color;
    }

    public void updateCursor(float saturation, float brightness) {
        this.cursorX = (int)class_3532.method_15363((float)((float)this.field_22758 * saturation), (float)0.0f, (float)this.field_22758);
        this.cursorY = (int)class_3532.method_15363((float)((float)this.field_22759 * (1.0f - brightness)), (float)0.0f, (float)this.field_22759);
    }

    private void updateValue(double x, double y) {
        float newSaturation = (float)class_3532.method_15350((double)(x / (double)this.method_25368()), (double)0.0, (double)1.0);
        float newBrightness = (float)(1.0 - class_3532.method_15350((double)(y / (double)this.method_25364()), (double)0.0, (double)1.0));
        this.colorPickerScreen.setSaturation(newSaturation);
        this.colorPickerScreen.setBrightness(newBrightness);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

