/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.container.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.inventory.PersonalStorageUtilitiesFeature;
import com.wynntils.mc.extension.ScreenExtension;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.type.QuickJumpButtonIcon;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.container.widgets.PersonalStorageEditModeButton;
import com.wynntils.screens.container.widgets.QuickJumpButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_6382;

public class PersonalStorageUtilitiesWidget
extends class_339 {
    private static final int BUTTON_SPACING = 18;
    private final PersonalStorageContainer container;
    private final List<QuickJumpButton> quickJumpButtons = new ArrayList<QuickJumpButton>();
    private final PersonalStorageEditModeButton editButton;
    private final TextInputBoxWidget editInput;
    private final PersonalStorageUtilitiesFeature feature;
    private final class_465<?> screen;
    private String pageName;

    public PersonalStorageUtilitiesWidget(int x, int y, PersonalStorageContainer container, PersonalStorageUtilitiesFeature feature, class_465<?> screen) {
        super(x, y, 100, 110, (class_2561)class_2561.method_43470((String)"Personal Storage Utilities Widget"));
        this.container = container;
        this.feature = feature;
        this.screen = screen;
        this.editButton = new PersonalStorageEditModeButton(x + 86, y + 9, 14, 14, this);
        int n = this.method_46426() + 2;
        int n2 = this.method_46427() + 10;
        int n3 = this.method_25368() - 18;
        Objects.requireNonNull(FontRenderer.getInstance().getFont());
        this.editInput = new TextInputBoxWidget(n, n2, n3, 9 + 2, null, (ScreenExtension)screen);
        this.editInput.setTextBoxInput(Models.Bank.getPageCustomization(Models.Bank.getCurrentPage()).getName());
        this.editInput.field_22764 = false;
        screen.method_37063((class_364)this.editInput);
        this.updatePageName();
        this.addJumpButtons();
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.BANK_PANEL, this.method_46426(), this.method_46427());
        if (!Models.Bank.isEditingMode()) {
            FontRenderer.getInstance().renderScrollingText(guiGraphics.method_51448(), StyledText.fromString(this.pageName), this.method_46426() + 4, this.method_46427() + 11, this.method_25368() - 18, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
        }
        this.editButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.editInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.quickJumpButtons.forEach(button -> button.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 class_3642 : this.quickJumpButtons) {
            if (!class_3642.method_25405(mouseX, mouseY)) continue;
            return class_3642.method_25402(mouseX, mouseY, button);
        }
        if (this.editButton.method_25405(mouseX, mouseY)) {
            return this.editButton.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public void jumpToPage(int destination) {
        this.toggleEditMode(false);
        this.feature.jumpToDestination(destination);
    }

    public void toggleEditMode(boolean on) {
        this.editInput.field_22764 = on;
        this.editInput.setTextBoxInput(Models.Bank.getPageCustomization(Models.Bank.getCurrentPage()).getName());
        Models.Bank.toggleEditingMode(on);
    }

    public void updatePageName() {
        this.pageName = Models.Bank.getPageCustomization(Models.Bank.getCurrentPage()).getName();
    }

    public void updatePageIcons() {
        for (int i = 0; i < this.quickJumpButtons.size(); ++i) {
            QuickJumpButton button = this.quickJumpButtons.get(i);
            button.setIcon(Models.Bank.getPageCustomization(i + 1).getIcon());
        }
    }

    public void saveEditModeChanges() {
        this.feature.saveEditModeChanges();
    }

    public String getName() {
        return this.editInput.getTextBoxInput();
    }

    public QuickJumpButtonIcon getPageIcon(int page) {
        QuickJumpButton button = this.quickJumpButtons.get(page - 1);
        return button.getIcon();
    }

    private void addJumpButtons() {
        int renderX = this.method_46426() + 6;
        int renderY = this.method_46427() + 23;
        for (int i = 0; i < this.container.getFinalPage(); ++i) {
            this.quickJumpButtons.add(new QuickJumpButton(renderX, renderY, i + 1, this.feature.getLockedQuickJumpColor(), this.feature.getSelectedQuickJumpColor(), Models.Bank.getPageCustomization(i + 1).getIcon(), this));
            renderX += 18;
            if ((i + 1) % 5 != 0) continue;
            renderX = this.method_46426() + 6;
            renderY += 18;
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

