/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.aspect;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.models.aspects.type.AspectInfo;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class GuideAspectItemStack
extends GuideItemStack {
    private static final class_5250 LEGENDARY_TAG = class_2561.method_43470((String)"\ue060\udaff\udfff\ue03b\udaff\udfff\ue034\udaff\udfff\ue036\udaff\udfff\ue034\udaff\udfff\ue03d\udaff\udfff\ue033\udaff\udfff\ue030\udaff\udfff\ue041\udaff\udfff\ue048\udaff\udfff\ue061\udaff\udfff\ue030\udaff\udfff\ue042\udaff\udfff\ue03f\udaff\udfff\ue034\udaff\udfff\ue032\udaff\udfff\ue043\udaff\udfff\ue062\udaff\udfa0\u00a70\ue00b\ue004\ue006\ue004\ue00d\ue003\ue000\ue011\ue018 \ue000\ue012\ue00f\ue004\ue002\ue013\udb00\udc02");
    private static final class_5250 FABLED_TAG = class_2561.method_43470((String)"\ue060\udaff\udfff\ue035\udaff\udfff\ue030\udaff\udfff\ue031\udaff\udfff\ue03b\udaff\udfff\ue034\udaff\udfff\ue033\udaff\udfff\ue061\udaff\udfff\ue030\udaff\udfff\ue042\udaff\udfff\ue03f\udaff\udfff\ue034\udaff\udfff\ue032\udaff\udfff\ue043\udaff\udfff\ue062\udaff\udfb2\u00a70\ue005\ue000\ue001\ue00b\ue004\ue003 \ue000\ue012\ue00f\ue004\ue002\ue013\udb00\udc02");
    private static final class_5250 MYTHIC_TAG = class_2561.method_43470((String)"\ue060\udaff\udfff\ue03c\udaff\udfff\ue048\udaff\udfff\ue043\udaff\udfff\ue037\udaff\udfff\ue038\udaff\udfff\ue032\udaff\udfff\ue061\udaff\udfff\ue030\udaff\udfff\ue042\udaff\udfff\ue03f\udaff\udfff\ue034\udaff\udfff\ue032\udaff\udfff\ue043\udaff\udfff\ue062\udaff\udfb4\u00a70\ue00c\ue018\ue013\ue007\ue008\ue002 \ue000\ue012\ue00f\ue004\ue002\ue013\udb00\udc02");
    private static final class_2960 RARITY_TAG_FONT = class_2960.method_60656((String)"banner/box");
    private final AspectInfo aspectInfo;
    private final class_5250 name;
    private final int tier;
    private List<class_2561> generatedTooltip;

    public GuideAspectItemStack(AspectInfo aspectInfo, int tier) {
        super(aspectInfo.itemMaterial().itemStack(), new AspectItem(aspectInfo, tier), aspectInfo.name());
        this.aspectInfo = aspectInfo;
        this.name = class_2561.method_43470((String)aspectInfo.name()).method_27692(aspectInfo.gearTier().getChatFormatting());
        this.tier = tier;
        this.buildTooltip();
    }

    public class_2561 method_7964() {
        return this.name;
    }

    public List<class_2561> method_7950(class_1792.class_9635 context, class_1657 player, class_1836 flag) {
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>(this.generatedTooltip);
        tooltipLines.add((class_2561)class_2561.method_43473());
        if (Services.Favorites.isFavorite(this)) {
            tooltipLines.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").method_27692(class_124.field_1054));
        } else {
            tooltipLines.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").method_27692(class_124.field_1060));
        }
        return tooltipLines;
    }

    public void buildTooltip() {
        this.generatedTooltip = new ArrayList<class_2561>();
        this.generatedTooltip.add((class_2561)class_2561.method_43470((String)this.aspectInfo.name()).method_27692(this.aspectInfo.gearTier().getChatFormatting()));
        this.generatedTooltip.add((class_2561)class_2561.method_43473());
        int threshold = this.aspectInfo.effects().get(this.tier - 1).a();
        if (this.tier > 1) {
            threshold -= this.aspectInfo.effects().get(this.tier - 2).a().intValue();
        }
        class_5250 tierLine = this.tier == this.aspectInfo.effects().size() ? class_2561.method_43470((String)("           Tier " + MathUtils.toRoman(this.tier))).method_27692(this.aspectInfo.gearTier().getChatFormatting()).method_10852((class_2561)class_2561.method_43470((String)(" [" + threshold + "] [MAX]")).method_27692(class_124.field_1080)) : class_2561.method_43470((String)("     Tier " + MathUtils.toRoman(this.tier))).method_27692(this.aspectInfo.gearTier().getChatFormatting()).method_10852((class_2561)class_2561.method_43470((String)" / ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("Tier " + MathUtils.toRoman(this.tier + 1))).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(" [" + threshold + "]")).method_27692(class_124.field_1080));
        this.generatedTooltip.add((class_2561)tierLine);
        this.generatedTooltip.add((class_2561)class_2561.method_43473());
        this.aspectInfo.effects().get(this.tier - 1).b().forEach(line -> this.generatedTooltip.add((class_2561)line.getComponent()));
        this.generatedTooltip.add((class_2561)class_2561.method_43473());
        class_5250 classLine = Models.Character.getClassType() == this.aspectInfo.classType() ? class_2561.method_43470((String)"\u2714 ").method_27692(class_124.field_1060) : class_2561.method_43470((String)"\u2716 ").method_27692(class_124.field_1061);
        classLine.method_10852((class_2561)class_2561.method_43470((String)"Class Req: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)this.aspectInfo.classType().getFullName()).method_27692(class_124.field_1068));
        this.generatedTooltip.add((class_2561)classLine);
        this.generatedTooltip.add((class_2561)class_2561.method_43473());
        class_2583 rarityStyle = class_2583.field_24360.method_10977(this.aspectInfo.gearTier().getChatFormatting()).method_27704(RARITY_TAG_FONT);
        class_5250 rarityLine = this.getRarityTag().method_27696(rarityStyle);
        this.generatedTooltip.add((class_2561)rarityLine);
    }

    public AspectInfo getAspectInfo() {
        return this.aspectInfo;
    }

    public int getTier() {
        return this.tier;
    }

    private class_5250 getRarityTag() {
        return switch (this.aspectInfo.gearTier()) {
            case GearTier.MYTHIC -> MYTHIC_TAG;
            case GearTier.FABLED -> FABLED_TAG;
            default -> LEGENDARY_TAG;
        };
    }
}

