/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.ingredient;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.ingredients.type.IngredientPosition;
import com.wynntils.models.ingredients.type.IngredientTierFormatting;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class GuideIngredientItemStack
extends GuideItemStack {
    private final IngredientInfo ingredientInfo;
    private final List<class_5250> guideTooltip;

    public GuideIngredientItemStack(IngredientInfo ingredientInfo) {
        super(ingredientInfo.material().itemStack(), new IngredientItem(ingredientInfo), ingredientInfo.name());
        this.ingredientInfo = ingredientInfo;
        this.guideTooltip = this.generateGuideTooltip();
    }

    public List<class_2561> method_7950(class_1792.class_9635 context, class_1657 player, class_1836 isAdvanced) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add(this.method_7964());
        tooltip.addAll(this.guideTooltip);
        this.appendObtainInfo(tooltip, Models.Ingredient.getObtainInfo(this.ingredientInfo));
        tooltip.add((class_2561)class_2561.method_43473());
        if (Services.Favorites.isFavorite(this.ingredientInfo.name())) {
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").method_27692(class_124.field_1054));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").method_27692(class_124.field_1060));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.open").method_27692(class_124.field_1061));
        return tooltip;
    }

    public class_2561 method_7964() {
        return class_2561.method_43470((String)this.ingredientInfo.name()).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(" " + this.getTierString(this.ingredientInfo.tier()))));
    }

    private String getTierString(int tier) {
        String tierString = IngredientTierFormatting.fromTierNum(tier).getTierString();
        if (tierString == null) {
            WynntilsMod.warn("Invalid ingredient tier for: " + this.ingredientInfo.name() + ": " + tier);
            return "";
        }
        return tierString;
    }

    private List<class_5250> generateGuideTooltip() {
        ArrayList<class_5250> itemLore = new ArrayList<class_5250>();
        itemLore.add(class_2561.method_43470((String)"Crafting Ingredient").method_27692(class_124.field_1063));
        itemLore.add(class_2561.method_43473());
        itemLore.addAll(this.getStatsLore(this.ingredientInfo));
        itemLore.addAll(this.getPositionModifierLore(this.ingredientInfo));
        itemLore.addAll(this.getEffectsAndRequirementsLore(this.ingredientInfo));
        itemLore.add(class_2561.method_43470((String)("Crafting Lv. Min: " + this.ingredientInfo.level())).method_27692(class_124.field_1080));
        for (ProfessionType profession : this.ingredientInfo.professions()) {
            itemLore.add(class_2561.method_43470((String)("  " + profession.getProfessionIconChar() + " ")).method_10852((class_2561)class_2561.method_43470((String)profession.getDisplayName()).method_27692(class_124.field_1080)));
        }
        return itemLore;
    }

    private List<class_5250> getStatsLore(IngredientInfo ingredientInfo) {
        ArrayList<class_5250> itemLore = new ArrayList<class_5250>();
        for (Pair<StatType, RangedValue> valuedStat : ingredientInfo.variableStats()) {
            if (valuedStat.value().isFixed()) {
                if (valuedStat.value().low() >= 0) {
                    itemLore.add(class_2561.method_43470((String)("+" + valuedStat.value().low() + valuedStat.key().getUnit().getDisplayName())).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)(" " + valuedStat.key().getDisplayName())).method_27692(class_124.field_1080)));
                    continue;
                }
                itemLore.add(class_2561.method_43470((String)(valuedStat.value().low() + valuedStat.key().getUnit().getDisplayName())).method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)(" " + valuedStat.key().getDisplayName())).method_27692(class_124.field_1080)));
                continue;
            }
            if (valuedStat.value().low() >= 0) {
                itemLore.add(class_2561.method_43470((String)("+" + valuedStat.value().low())).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(valuedStat.value().high() + valuedStat.key().getUnit().getDisplayName())).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(" " + valuedStat.key().getDisplayName())).method_27692(class_124.field_1080)));
                continue;
            }
            itemLore.add(class_2561.method_43470((String)String.valueOf(valuedStat.value().low())).method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)(valuedStat.value().high() + valuedStat.key().getUnit().getDisplayName())).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(" " + valuedStat.key().getDisplayName())).method_27692(class_124.field_1080)));
        }
        if (!itemLore.isEmpty()) {
            itemLore.add(class_2561.method_43473());
        }
        return itemLore;
    }

    private List<class_5250> getPositionModifierLore(IngredientInfo ingredientInfo) {
        ArrayList<class_5250> itemLore = new ArrayList<class_5250>();
        for (Map.Entry<IngredientPosition, Integer> modifier : ingredientInfo.positionModifiers().entrySet()) {
            int value = modifier.getValue();
            Object colorCode = value > 0 ? String.valueOf(class_124.field_1060) + "+" : class_124.field_1061.toString();
            itemLore.add(class_2561.method_43470((String)((String)colorCode + value + "%" + String.valueOf(class_124.field_1080) + " Ingredient Effectiveness")));
            itemLore.add(class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "(To ingredients " + modifier.getKey().getDisplayName() + " this one)")));
        }
        if (!itemLore.isEmpty()) {
            itemLore.add(class_2561.method_43473());
        }
        return itemLore;
    }

    private List<class_5250> getEffectsAndRequirementsLore(IngredientInfo ingredientInfo) {
        ArrayList<class_5250> itemLore = new ArrayList<class_5250>();
        if (ingredientInfo.durabilityModifier() != 0 && ingredientInfo.duration() != 0) {
            int durability;
            duration = ingredientInfo.duration();
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Durability", durability, (durability = ingredientInfo.durabilityModifier()) > 0).method_10852((class_2561)class_2561.method_43470((String)" or ").method_27692(class_124.field_1080)).method_10852((class_2561)GuideIngredientItemStack.getEffectsAndRequirementsLine("Duration", duration, duration > 0)));
        } else if (ingredientInfo.durabilityModifier() != 0) {
            int durability;
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Durability", durability, (durability = ingredientInfo.durabilityModifier()) > 0));
        } else if (ingredientInfo.duration() != 0) {
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Duration", duration, (duration = ingredientInfo.duration()) > 0));
        }
        if (ingredientInfo.charges() != 0) {
            int charges;
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Charges", charges, (charges = ingredientInfo.charges()) > 0));
        }
        for (Pair<Skill, Integer> skillReq : ingredientInfo.skillRequirements()) {
            int minLevel = skillReq.value();
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine(skillReq.key().getDisplayName() + " Min.", minLevel, minLevel < 0));
        }
        if (!itemLore.isEmpty()) {
            itemLore.add(class_2561.method_43473());
        }
        return itemLore;
    }

    private static class_5250 getEffectsAndRequirementsLine(String effectName, int value, boolean isGood) {
        return class_2561.method_43470((String)(StringUtils.toSignedString(value) + " " + effectName)).method_27692(isGood ? class_124.field_1060 : class_124.field_1061);
    }

    public IngredientInfo getIngredientInfo() {
        return this.ingredientInfo;
    }
}

