/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.services.itemfilter.filters.AnyStatFilters;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.services.itemfilter.type.StatValue;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ProviderButton
extends WynntilsButton {
    private static final CustomColor ENABLED_COLOR = new CustomColor(0, 220, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER = new CustomColor(0, 116, 0, 255);
    private static final CustomColor ENABLED_COLOR_BORDER_HOVERED = new CustomColor(0, 66, 0, 255);
    private static final CustomColor DISABLED_COLOR = new CustomColor(255, 0, 0, 255);
    private static final CustomColor DISABLED_COLOR_BORDER = new CustomColor(120, 0, 0, 255);
    private static final CustomColor DISABLED_COLOR_BORDER_HOVERED = new CustomColor(70, 0, 0, 255);
    private static final Map<Class<?>, AnyStatFilters.AbstractAnyStatFilter> ANY_MAP = Map.of(String.class, new AnyStatFilters.AnyStringStatFilter(), Integer.class, new AnyStatFilters.AnyIntegerStatFilter(), CappedValue.class, new AnyStatFilters.AnyCappedValueStatFilter(), StatValue.class, new AnyStatFilters.AnyStatValueStatFilter());
    private final ItemFilterScreen filterScreen;
    private final ItemStatProvider<?> provider;
    private final List<class_2561> tooltip;

    public ProviderButton(int x, int y, int width, int height, ItemFilterScreen filterScreen, ItemStatProvider<?> provider) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)provider.getTranslatedName()));
        this.filterScreen = filterScreen;
        this.provider = provider;
        this.tooltip = provider.getType().equals(Boolean.class) ? List.of(class_2561.method_43470((String)provider.getDescription()), class_2561.method_43471((String)"screens.wynntils.itemFilter.providerHelp2")) : List.of(class_2561.method_43470((String)provider.getDescription()), class_2561.method_43471((String)"screens.wynntils.itemFilter.providerHelp1"), class_2561.method_43471((String)"screens.wynntils.itemFilter.providerHelp2"));
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawRect(poseStack, this.getRectColor().withAlpha(100), this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        RenderUtils.drawRectBorders(poseStack, this.getBorderColor(), this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 1.0f, 2.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.provider.getDisplayName()), this.method_46426() + 2, (float)this.method_46427() + (float)this.field_22759 / 2.0f, this.field_22758 - 4, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        if (this.field_22762 && (mouseY <= this.filterScreen.getProviderMaskTopY() || mouseY >= this.filterScreen.getProviderMaskBottomY())) {
            this.field_22762 = false;
        }
        if (this.field_22762) {
            McUtils.screen().method_47414(Lists.transform(this.tooltip, class_2561::method_30937));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.filterScreen.getProviderMaskTopY() || mouseY >= (double)this.filterScreen.getProviderMaskBottomY()) {
            return false;
        }
        if (this.filterScreen.inSortMode()) {
            if (button == 0) {
                this.filterScreen.addSort(new SortInfo(SortDirection.ASCENDING, this.provider));
            } else if (button == 1) {
                this.filterScreen.removeSort(this.provider);
            }
        } else {
            AnyStatFilters.AbstractAnyStatFilter anyFilter;
            if (button == 0) {
                this.filterScreen.setSelectedProvider(this.provider);
            } else if (button == 1) {
                this.filterScreen.setFiltersForProvider(this.provider, null);
            } else if (button == 2 && (anyFilter = (AnyStatFilters.AbstractAnyStatFilter)ANY_MAP.getOrDefault(this.provider.getType(), null)) != null) {
                this.filterScreen.setFiltersForProvider(this.provider, List.of(new StatProviderAndFilterPair(this.provider, anyFilter)));
            }
            this.filterScreen.updateFilterWidget();
        }
        return true;
    }

    public void method_25306() {
    }

    private CustomColor getRectColor() {
        ItemFilterScreen itemFilterScreen;
        class_437 class_4372 = McUtils.screen();
        if (class_4372 instanceof ItemFilterScreen && (itemFilterScreen = (ItemFilterScreen)class_4372).getSelectedProvider() == this.provider) {
            return CommonColors.GRAY;
        }
        return this.filterScreen.isProviderInUse(this.provider) ? ENABLED_COLOR : DISABLED_COLOR;
    }

    private CustomColor getBorderColor() {
        ItemFilterScreen itemFilterScreen;
        class_437 class_4372 = McUtils.screen();
        if (class_4372 instanceof ItemFilterScreen && (itemFilterScreen = (ItemFilterScreen)class_4372).getSelectedProvider() == this.provider) {
            return this.field_22762 ? CommonColors.LIGHT_GRAY : CommonColors.WHITE;
        }
        return this.filterScreen.isProviderInUse(this.provider) ? (this.field_22762 ? ENABLED_COLOR_BORDER_HOVERED : ENABLED_COLOR_BORDER) : (this.field_22762 ? DISABLED_COLOR_BORDER_HOVERED : DISABLED_COLOR_BORDER);
    }
}

