/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class StringFilterWidget
extends GeneralFilterWidget {
    private final class_4185 removeButton;
    private final TextInputBoxWidget entryInput;
    private final WynntilsCheckbox strictCheckbox;
    private boolean ignoreUpdate = false;

    public StringFilterWidget(int x, int y, int width, int height, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"String Filter Widget"), parent);
        StatFilter statFilter;
        int inputWidth = width - 77;
        this.entryInput = new TextInputBoxWidget(this.method_46426(), this.method_46427(), inputWidth, this.method_25364(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        boolean strict = false;
        if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof StringStatFilter) {
            StringStatFilter stringStatFilter = (StringStatFilter)statFilter;
            this.ignoreUpdate = true;
            strict = stringStatFilter.isStrict();
            this.entryInput.setTextBoxInput(stringStatFilter.getSearchLiteral());
            this.ignoreUpdate = false;
        }
        this.strictCheckbox = new WynntilsCheckbox(this.method_46426() + inputWidth + 2, this.method_46427(), 20, (class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.strict"), strict, 50, (checkbox, bl) -> {
            if (bl.booleanValue()) {
                parent.updateQuery();
            }
        }, List.of(class_2561.method_43471((String)"screens.wynntils.itemFilter.strictTooltip")));
        this.removeButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83d\uddd1"), button -> parent.removeWidget(this)).method_46433(this.method_46426() + inputWidth + 54, this.method_46427()).method_46437(20, 20).method_46431();
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.entryInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.strictCheckbox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.entryInput.method_25405(mouseX, mouseY)) {
            return this.entryInput.method_25402(mouseX, mouseY, button);
        }
        if (this.strictCheckbox.method_25405(mouseX, mouseY)) {
            return this.strictCheckbox.method_25402(mouseX, mouseY, button);
        }
        if (this.removeButton.method_25405(mouseX, mouseY)) {
            return this.removeButton.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.entryInput.method_25405(mouseX, mouseY)) {
            return this.entryInput.method_25406(mouseX, mouseY, button);
        }
        if (this.strictCheckbox.method_25405(mouseX, mouseY)) {
            return this.strictCheckbox.method_25406(mouseX, mouseY, button);
        }
        if (this.removeButton.method_25405(mouseX, mouseY)) {
            return this.removeButton.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.method_46419(y);
        this.entryInput.method_46419(y);
        this.strictCheckbox.method_46419(y);
        this.removeButton.method_46419(y);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.entryInput.getTextBoxInput().isEmpty()) {
            return null;
        }
        Object input = this.strictCheckbox.selected ? "\"" + this.entryInput.getTextBoxInput() + "\"" : this.entryInput.getTextBoxInput();
        Optional<StringStatFilter> statFilterOpt = new StringStatFilter.StringStatFilterFactory().create((String)input);
        return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<String>(this.parent.getProvider(), (StatFilter<String>)stringStatFilter)).orElse(null);
    }
}

