/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.screens.itemfilter.widgets.numeric.InequalityNumericFilterWidget;
import com.wynntils.services.itemfilter.filters.RangedStatFilters;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.type.CappedValue;
import java.util.Optional;

public class InequalityCappedValueFilterWidget
extends InequalityNumericFilterWidget<CappedValue> {
    public InequalityCappedValueFilterWidget(int x, int y, int width, int height, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, parent, filterScreen);
        StatFilter statFilter;
        if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof RangedStatFilters.RangedCappedValueStatFilter) {
            RangedStatFilters.RangedCappedValueStatFilter cappedValueStatFilter = (RangedStatFilters.RangedCappedValueStatFilter)statFilter;
            if (cappedValueStatFilter.getMin() != Integer.MIN_VALUE && cappedValueStatFilter.getMax() == Integer.MAX_VALUE) {
                if (cappedValueStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(cappedValueStatFilter.getMin()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN);
                    this.setEntryInput(String.valueOf(cappedValueStatFilter.getMin() - 1));
                }
            } else if (cappedValueStatFilter.getMax() != Integer.MAX_VALUE && cappedValueStatFilter.getMin() == Integer.MIN_VALUE) {
                if (cappedValueStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(cappedValueStatFilter.getMax()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN);
                    this.setEntryInput(String.valueOf(cappedValueStatFilter.getMax() + 1));
                }
            }
        }
    }

    @Override
    protected Optional<StatFilter<CappedValue>> getInequalityStatFilter(String value, InequalityNumericFilterWidget.InequalityType inequalityType) {
        return new RangedStatFilters.RangedCappedValueStatFilter.RangedCappedValueStatFilterFactory().create(inequalityType.getMessage() + value).map(f -> f);
    }
}

