/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemsharing;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.items.game.CraftedConsumableItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemsharing.SavedItemsScreen;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ErrorOr;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

public final class ItemSharingScreen
extends WynntilsScreen {
    private final class_1799 itemStack;
    private final WynnItem wynnItem;
    private final class_437 previousScreen;
    private boolean savedItem = false;
    private class_4185 saveButton;
    private EncodedByteBuffer encodedItem;
    private int backgroundX;
    private int backgroundY;
    private int tooltipX;
    private class_1799 previewItemStack;
    private List<class_339> options = new ArrayList<class_339>();

    private ItemSharingScreen(WynnItem wynnItem, class_1799 itemStack) {
        super((class_2561)class_2561.method_43470((String)"Item Sharing Screen"));
        this.wynnItem = wynnItem;
        this.itemStack = itemStack;
        this.previousScreen = McUtils.screen();
    }

    private ItemSharingScreen(WynnItem wynnItem, class_1799 itemStack, boolean savedItem) {
        super((class_2561)class_2561.method_43470((String)"Item Sharing Screen"));
        this.wynnItem = wynnItem;
        this.itemStack = itemStack;
        this.savedItem = savedItem;
        this.previousScreen = McUtils.screen();
    }

    public static class_437 create(WynnItem wynnItem, class_1799 itemStack) {
        return new ItemSharingScreen(wynnItem, itemStack);
    }

    public static class_437 create(WynnItem wynnItem, class_1799 itemStack, boolean savedItem) {
        return new ItemSharingScreen(wynnItem, itemStack, savedItem);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.backgroundY = (this.field_22790 - Texture.ITEM_SHARING_BACKGROUND.height()) / 2;
        this.refreshPreview();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.sharingOptions").method_27692(class_124.field_1067)), this.backgroundX + 10, this.backgroundY + 10, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        this.renderPreview(guiGraphics);
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.ITEM_SHARING_BACKGROUND, this.backgroundX, this.backgroundY);
    }

    public void method_25419() {
        McUtils.setScreen(this.previousScreen);
    }

    private void renderPreview(class_332 guiGraphics) {
        if (this.previewItemStack == null) {
            return;
        }
        class_327 class_3272 = FontRenderer.getInstance().getFont();
        Objects.requireNonNull(FontRenderer.getInstance().getFont());
        guiGraphics.method_51446(class_3272, this.previewItemStack, this.tooltipX, this.backgroundY + 9 * 2);
    }

    private void refreshPreview() {
        String string;
        EncodingSettings encodingSettings = new EncodingSettings((Boolean)Models.ItemEncoding.extendedIdentificationEncoding.get(), (Boolean)Models.ItemEncoding.shareItemName.get());
        ErrorOr<EncodedByteBuffer> errorOrEncodedByteBuffer = Models.ItemEncoding.encodeItem(this.wynnItem, encodingSettings);
        if (errorOrEncodedByteBuffer.hasError()) {
            WynntilsMod.error("Failed to encode item: " + errorOrEncodedByteBuffer.getError());
            this.previewItemStack = null;
            this.backgroundX = (this.field_22789 - Texture.ITEM_SHARING_BACKGROUND.width()) / 2;
            this.method_37067();
            this.addError(errorOrEncodedByteBuffer.getError());
            return;
        }
        this.encodedItem = errorOrEncodedByteBuffer.getValue();
        WynnItem wynnItem = this.wynnItem;
        if (wynnItem instanceof NamedItemProperty) {
            NamedItemProperty namedItem = (NamedItemProperty)((Object)wynnItem);
            string = namedItem.getName();
        } else {
            string = null;
        }
        String itemName = string;
        ErrorOr<WynnItem> errorOrDecodedByteBuffer = Models.ItemEncoding.decodeItem(this.encodedItem, itemName);
        if (errorOrDecodedByteBuffer.hasError()) {
            WynntilsMod.error("Failed to decode item: " + errorOrDecodedByteBuffer.getError());
            this.previewItemStack = null;
            this.backgroundX = (this.field_22789 - Texture.ITEM_SHARING_BACKGROUND.width()) / 2;
            this.method_37067();
            this.addError(errorOrDecodedByteBuffer.getError());
            return;
        }
        WynnItem renderedItem = errorOrDecodedByteBuffer.getValue();
        this.previewItemStack = new FakeItemStack(renderedItem, "From chat");
        int tooltipWidth = LoreUtils.getTooltipLines(this.previewItemStack).stream().map(component -> McUtils.mc().field_1772.method_27525((class_5348)component)).max(Integer::compareTo).orElse(0);
        int totalRenderWidth = tooltipWidth + Texture.ITEM_SHARING_BACKGROUND.width() + 10;
        int sideGap = Math.abs((this.field_22789 - totalRenderWidth) / 2);
        this.tooltipX = this.field_22789 - sideGap - tooltipWidth - 20;
        this.backgroundX = Math.max(0, sideGap - 10);
        for (class_339 widget : this.options) {
            this.method_37066((class_364)widget);
        }
        this.options = new ArrayList<class_339>();
        this.addSharingOptions();
    }

    private void shareItem(String target) {
        switch (target) {
            case "guild": {
                Handlers.Command.sendCommandImmediately("g " + Models.ItemEncoding.makeItemString(this.wynnItem, this.encodedItem));
                break;
            }
            case "party": {
                Handlers.Command.sendCommandImmediately("p " + Models.ItemEncoding.makeItemString(this.wynnItem, this.encodedItem));
                break;
            }
            case "save": {
                class_1799 itemStackToSave = this.itemStack;
                WynnItem wynnItem = this.wynnItem;
                if (wynnItem instanceof GearItem) {
                    GearItem gearItem = (GearItem)wynnItem;
                    itemStackToSave = new FakeItemStack(gearItem, "From " + McUtils.playerName() + "'s Item Record");
                }
                this.savedItem = Services.ItemRecord.saveItem(this.wynnItem, itemStackToSave, this.itemStack.method_7964());
                if (!this.savedItem) break;
                this.saveButton.method_25355((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.openRecord"));
                break;
            }
            default: {
                McUtils.mc().field_1774.method_1455(Models.ItemEncoding.makeItemString(this.wynnItem, this.encodedItem));
                McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.copied").method_27692(class_124.field_1060));
            }
        }
    }

    private void addSharingOptions() {
        if (this.wynnItem instanceof IdentifiableItemProperty) {
            this.options.add((class_339)this.method_37063((class_364)new WynntilsCheckbox(this.backgroundX + 15, this.backgroundY + 25, 10, (class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.extended.name"), (Boolean)Models.ItemEncoding.extendedIdentificationEncoding.get(), Texture.ITEM_SHARING_BACKGROUND.width() - 30, (c, b) -> {
                Models.ItemEncoding.extendedIdentificationEncoding.store((Boolean)b);
                this.refreshPreview();
            }, ComponentUtils.wrapTooltips(List.of(class_2561.method_43471((String)"screens.wynntils.itemSharing.extended.description1"), class_2561.method_43471((String)"screens.wynntils.itemSharing.extended.description2")), 150))));
        } else if (this.wynnItem instanceof CraftedGearItem || this.wynnItem instanceof CraftedConsumableItem) {
            this.options.add((class_339)this.method_37063((class_364)new WynntilsCheckbox(this.backgroundX + 15, this.backgroundY + 25, 10, (class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.itemName.name"), (Boolean)Models.ItemEncoding.shareItemName.get(), Texture.ITEM_SHARING_BACKGROUND.width() - 30, (c, b) -> {
                Models.ItemEncoding.shareItemName.store((Boolean)b);
                this.refreshPreview();
            }, ComponentUtils.wrapTooltips(List.of(class_2561.method_43471((String)"screens.wynntils.itemSharing.itemName.description")), 150))));
        }
        int shareButtonWidth = (Texture.ITEM_SHARING_BACKGROUND.width() - 20) / 2 - 5;
        this.options.add((class_339)this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.shareParty"), b -> this.shareItem("party")).method_46433(this.backgroundX + 10, this.backgroundY + 45).method_46437(shareButtonWidth, 20).method_46431()));
        this.options.add((class_339)this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.shareGuild"), b -> this.shareItem("guild")).method_46433(this.backgroundX + 20 + shareButtonWidth, this.backgroundY + 45).method_46437(shareButtonWidth, 20).method_46431()));
        class_5250 saveButtonMessage = this.savedItem ? class_2561.method_43471((String)"screens.wynntils.itemSharing.openRecord") : class_2561.method_43471((String)"screens.wynntils.itemSharing.save");
        this.saveButton = new class_4185.class_7840((class_2561)saveButtonMessage, b -> {
            if (!this.savedItem) {
                this.shareItem("save");
            } else {
                McUtils.setScreen(SavedItemsScreen.create());
            }
        }).method_46433(this.backgroundX + 10, this.backgroundY + Texture.ITEM_SHARING_BACKGROUND.height() - 30).method_46437(shareButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.options.add((class_339)this.saveButton);
        this.options.add((class_339)this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.copy"), b -> this.shareItem("clipboard")).method_46433(this.backgroundX + 20 + shareButtonWidth, this.backgroundY + Texture.ITEM_SHARING_BACKGROUND.height() - 30).method_46437(shareButtonWidth, 20).method_46431()));
    }

    private void addError(String error) {
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSharing.error"), b -> {}).method_46433(this.backgroundX + 10, this.backgroundY + Texture.ITEM_SHARING_BACKGROUND.height() - 30).method_46437(Texture.ITEM_SHARING_BACKGROUND.width() - 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)error))).method_46431());
    }
}

