/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.maps.CustomSeaskipperScreen;
import com.wynntils.services.map.pois.SeaskipperDestinationPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class SeaskipperDestinationButton
extends WynntilsButton {
    private final SeaskipperDestinationPoi destination;
    private final CustomSeaskipperScreen seaskipperScreen;

    public SeaskipperDestinationButton(int x, int y, int width, int height, SeaskipperDestinationPoi destination, CustomSeaskipperScreen seaskipperScreen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Destination Button"));
        this.destination = destination;
        this.seaskipperScreen = seaskipperScreen;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawTexturedRect(poseStack, Texture.DESTINATION_BUTTON.resource(), this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759, 0, this.field_22762 || this.seaskipperScreen.getSelectedDestination() == this.destination ? Texture.DESTINATION_BUTTON.height() / 2 : 0, Texture.DESTINATION_BUTTON.width(), Texture.DESTINATION_BUTTON.height() / 2, Texture.DESTINATION_BUTTON.width(), Texture.DESTINATION_BUTTON.height());
        float x = (float)this.method_46426() + (float)this.field_22758 * 0.05f;
        float y = (float)this.method_46427() + (float)this.field_22759 * 0.16f;
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43469((String)"screens.wynntils.customSeaskipperScreen.destination", (Object[])new Object[]{this.destination.getName(), this.destination.getLevel()})), x, y + 1.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, (float)this.field_22759 * 0.032f);
        CustomColor priceColor = Models.Emerald.getAmountInInventory() >= this.destination.getDestination().item().getPrice() ? CommonColors.GREEN : CommonColors.RED;
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43469((String)"screens.wynntils.customSeaskipperScreen.cost", (Object[])new Object[]{this.destination.getDestination().item().getPrice()})), x, y + 10.0f, priceColor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE, (float)this.field_22759 * 0.032f);
        if (this.field_22762) {
            List<class_5250> tooltip = this.seaskipperScreen.getSelectedDestination() == this.destination ? List.of(class_2561.method_43469((String)"screens.wynntils.customSeaskipperScreen.travelToDestination", (Object[])new Object[]{this.destination.getName()}).method_27692(class_124.field_1080)) : List.of(class_2561.method_43469((String)"screens.wynntils.customSeaskipperScreen.select", (Object[])new Object[]{this.destination.getName()}).method_27692(class_124.field_1080));
            McUtils.screen().method_47414(Lists.transform(tooltip, class_2561::method_30937));
        }
    }

    public void method_25306() {
    }

    public SeaskipperDestinationPoi getDestination() {
        return this.destination;
    }
}

