/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.playerviewer;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.FakeItemStack;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.screens.base.WynntilsContainerScreen;
import com.wynntils.screens.base.widgets.InfoButton;
import com.wynntils.screens.playerviewer.GearSharingSettingsScreen;
import com.wynntils.screens.playerviewer.PlayerViewerMenu;
import com.wynntils.screens.playerviewer.widgets.FriendButton;
import com.wynntils.screens.playerviewer.widgets.PartyButton;
import com.wynntils.screens.playerviewer.widgets.PlayerInteractionButton;
import com.wynntils.screens.playerviewer.widgets.SimplePlayerInteractionButton;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_7919;
import net.minecraft.class_9280;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public final class PlayerViewerScreen
extends WynntilsContainerScreen<PlayerViewerMenu> {
    private static final String TEAM_NAME = "PlayerViewerTeam";
    private final class_1657 player;
    private final class_269 scoreboard;
    private final class_268 playerViewerTeam;
    private final class_268 oldTeam;
    private final List<PlayerInteractionButton> interactionButtons = new ArrayList<PlayerInteractionButton>();
    private class_4185 settingsButton;
    private FriendButton friendButton;
    private InfoButton infoButton;
    private PartyButton partyButton;
    private static boolean noGear = true;

    private PlayerViewerScreen(class_1657 player, PlayerViewerMenu menu) {
        super(menu, player.method_31548(), (class_2561)class_2561.method_43473());
        this.player = player;
        this.scoreboard = player.method_37908().method_8428();
        if (this.scoreboard.method_1196().contains(TEAM_NAME)) {
            this.playerViewerTeam = this.scoreboard.method_1153(TEAM_NAME);
        } else {
            this.playerViewerTeam = this.scoreboard.method_1171(TEAM_NAME);
            this.playerViewerTeam.method_1149(class_270.class_272.field_1443);
        }
        this.oldTeam = this.scoreboard.method_1164(player.method_5820());
        this.scoreboard.method_1172(player.method_5820(), this.playerViewerTeam);
    }

    public static class_437 create(class_1657 player) {
        Optional<HadesUser> hadesUserOpt = Services.Hades.getHadesUser(player.method_5667());
        class_1799 heldItem = class_1799.field_8037;
        ArrayList<class_1799> armorItems = new ArrayList<class_1799>();
        ArrayList<class_1799> accessoryItems = new ArrayList<class_1799>();
        if (hadesUserOpt.isPresent()) {
            WynnItem wynnItem;
            heldItem = PlayerViewerScreen.createDecoratedItemStack(hadesUserOpt.get().getHeldItem(), player.method_6047(), player);
            if (heldItem == null) {
                noGear = true;
                return new PlayerViewerScreen(player, PlayerViewerMenu.create(class_1799.field_8037, List.of(), List.of()));
            }
            noGear = heldItem.method_7960();
            for (InventoryAccessory inventoryAccessory : InventoryAccessory.values()) {
                wynnItem = (WynnItem)hadesUserOpt.get().getAccessories().get((Object)inventoryAccessory);
                if (wynnItem == null) {
                    accessoryItems.add(class_1799.field_8037);
                    continue;
                }
                class_1799 accessoryItemStack = PlayerViewerScreen.createDecoratedItemStack(wynnItem, class_1799.field_8037, player);
                if (accessoryItemStack == null) {
                    noGear = true;
                    return new PlayerViewerScreen(player, PlayerViewerMenu.create(class_1799.field_8037, List.of(), List.of()));
                }
                accessoryItems.add(accessoryItemStack);
                noGear = false;
            }
            for (Enum enum_ : InventoryArmor.values()) {
                wynnItem = (WynnItem)hadesUserOpt.get().getArmor().get(enum_);
                if (wynnItem == null) {
                    armorItems.add(class_1799.field_8037);
                    continue;
                }
                class_1799 armorItemStack = PlayerViewerScreen.createDecoratedItemStack(wynnItem, (class_1799)player.method_31548().field_7548.get(((InventoryArmor)enum_).getArmorSlot()), player);
                if (armorItemStack == null) {
                    noGear = true;
                    return new PlayerViewerScreen(player, PlayerViewerMenu.create(class_1799.field_8037, List.of(), List.of()));
                }
                armorItems.add(armorItemStack);
                noGear = false;
            }
        }
        return new PlayerViewerScreen(player, PlayerViewerMenu.create(heldItem, armorItems, accessoryItems));
    }

    private static class_1799 createDecoratedItemStack(WynnItem wynnItem, class_1799 expectedItem, class_1657 player) {
        class_1799 itemStack = class_1799.field_8037;
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            itemStack = gearItem.getItemInfo().metaInfo().material().itemStack();
            if (gearItem.getGearType() != GearType.HELMET && !gearItem.getGearType().isWeapon()) {
                class_9280 itemModelData;
                class_9280 expectedModelData = expectedItem.method_57826(class_9334.field_49637) ? (class_9280)expectedItem.method_57824(class_9334.field_49637) : null;
                class_9280 class_92802 = itemModelData = itemStack.method_57826(class_9334.field_49637) ? (class_9280)itemStack.method_57824(class_9334.field_49637) : null;
                if (expectedItem != class_1799.field_8037 && !expectedModelData.equals((Object)itemModelData)) {
                    return null;
                }
            }
        } else if (wynnItem instanceof CraftedGearItem) {
            CraftedGearItem craftedGearItem = (CraftedGearItem)wynnItem;
            if (craftedGearItem.getGearType().isArmor()) {
                itemStack = (class_1799)player.method_31548().field_7548.get(InventoryArmor.fromString(craftedGearItem.getGearType().name()).getArmorSlot());
            } else if (craftedGearItem.getGearType().isWeapon()) {
                itemStack = player.method_6047();
            } else {
                itemStack = new class_1799((class_1935)class_1802.field_8574);
                class_9280 customModelData = new class_9280(List.of(Float.valueOf(craftedGearItem.getGearType().getDefaultModel())), List.of(), List.of(), List.of());
                class_9323.class_9324 componentsBuilder = class_9323.method_57827().method_57840(class_9334.field_49637, (Object)customModelData);
                itemStack.method_57365(componentsBuilder.method_57838());
            }
        }
        return new FakeItemStack(wynnItem, itemStack, "From " + player.method_5820());
    }

    @Override
    protected void doInit() {
        this.interactionButtons.clear();
        this.field_2776 = (this.field_22789 - Texture.PLAYER_VIEWER_BACKGROUND.width()) / 2;
        this.field_2800 = (this.field_22790 - Texture.PLAYER_VIEWER_BACKGROUND.height()) / 2;
        String playerName = StyledText.fromComponent(this.player.method_5477()).getStringWithoutFormatting();
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.field_2776 - 21, this.field_2800 + (Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 - 2), (class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.viewStats"), Texture.STATS_ICON, () -> Managers.Net.openLink(UrlId.LINK_WYNNCRAFT_PLAYER_STATS, Map.of("username", playerName))));
        this.friendButton = new FriendButton(this.field_2776 - 21, this.field_2800 + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 18, playerName);
        this.interactionButtons.add(this.friendButton);
        this.partyButton = new PartyButton(this.field_2776 - 21, this.field_2800 + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 38, playerName);
        this.interactionButtons.add(this.partyButton);
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.field_2776 + Texture.PLAYER_VIEWER_BACKGROUND.width() + 1, this.field_2800 + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 - 2, (class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.duel"), Texture.DUEL_ICON, () -> Handlers.Command.queueCommand("duel " + playerName)));
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.field_2776 + Texture.PLAYER_VIEWER_BACKGROUND.width() + 1, this.field_2800 + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 18, (class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.trade"), Texture.TRADE_ICON, () -> Handlers.Command.queueCommand("trade " + playerName)));
        this.interactionButtons.add(new SimplePlayerInteractionButton(this.field_2776 + Texture.PLAYER_VIEWER_BACKGROUND.width() + 1, this.field_2800 + Texture.PLAYER_VIEWER_BACKGROUND.height() / 5 + 38, (class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.message"), Texture.MESSAGE_ICON, () -> {
            this.method_25419();
            McUtils.openChatScreen("/msg " + playerName + " ");
        }));
        this.settingsButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.sharingSettings"), b -> McUtils.setScreen(GearSharingSettingsScreen.create((class_437)this))).method_46433(this.field_2776 + 1, this.field_2800 - 21).method_46437(Texture.PLAYER_VIEWER_BACKGROUND.width() - 23, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.sharingSettingsTooltip"))).method_46431();
        if (noGear) {
            this.infoButton = new InfoButton(this.field_2776 + Texture.PLAYER_VIEWER_BACKGROUND.width() - 21, this.field_2800 - 21, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.helpTitle").method_27692(class_124.field_1073)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.playerViewer.help").method_27692(class_124.field_1080)));
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPlayerModel(guiGraphics, mouseX, mouseY);
        this.method_2380(guiGraphics, mouseX, mouseY);
        this.interactionButtons.forEach(button -> button.method_25394(guiGraphics, mouseX, mouseY, partialTick));
        this.settingsButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.infoButton == null) {
            return;
        }
        this.infoButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderPlayerModel(class_332 guiGraphics, int mouseX, int mouseY) {
        int renderX = (this.field_22789 - Texture.PLAYER_VIEWER_BACKGROUND.width()) / 2 + 13;
        int renderY = (this.field_22790 - Texture.PLAYER_VIEWER_BACKGROUND.height()) / 2 - 4;
        int renderWidth = Texture.PLAYER_VIEWER_BACKGROUND.width();
        int renderHeight = Texture.PLAYER_VIEWER_BACKGROUND.height();
        class_490.method_2486((class_332)guiGraphics, (int)renderX, (int)renderY, (int)(renderX + renderWidth), (int)(renderY + renderHeight), (int)30, (float)0.2f, (float)mouseX, (float)mouseY, (class_1309)this.player);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        BufferedRenderUtils.drawTexturedRect(guiGraphics.method_51448(), (class_4597)guiGraphics.field_44658, Texture.PLAYER_VIEWER_BACKGROUND, this.field_2776, this.field_2800);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (PlayerInteractionButton interactionButton : this.interactionButtons) {
            if (!interactionButton.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.settingsButton.method_25402(mouseX, mouseY, button);
    }

    protected void method_2383(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == McUtils.options().field_1822.field_1655.method_1444()) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.scoreboard.method_1157(this.player.method_5820(), this.playerViewerTeam);
        if (this.oldTeam != null) {
            this.scoreboard.method_1172(this.player.method_5820(), this.oldTeam);
        }
        super.method_25419();
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public void updateButtonIcons() {
        this.friendButton.updateIcon();
        this.partyButton.updateIcon();
    }
}

