/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.screens.settings.WynntilsBookSettingsScreen;
import com.wynntils.screens.settings.widgets.BooleanSettingsButton;
import com.wynntils.screens.settings.widgets.CustomColorSettingsButton;
import com.wynntils.screens.settings.widgets.EnumSettingsButton;
import com.wynntils.screens.settings.widgets.GeneralSettingsButton;
import com.wynntils.screens.settings.widgets.OverlaySettingsWidget;
import com.wynntils.screens.settings.widgets.ResetButton;
import com.wynntils.screens.settings.widgets.TextInputBoxSettingsWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ConfigTile
extends WynntilsButton {
    private final class_437 screen;
    private final int maskTopY;
    private final int maskBottomY;
    private final GeneralSettingsButton resetButton;
    private final StyledText displayName;
    private final Overlay overlay;
    private class_339 configOptionElement;

    public ConfigTile(int x, int y, int width, int height, class_437 screen, Config<?> config, Overlay overlay) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)config.getJsonName()));
        this.screen = screen;
        if (screen instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen settingsScreen = (WynntilsBookSettingsScreen)screen;
            this.maskTopY = settingsScreen.getMaskTopY();
            this.maskBottomY = settingsScreen.getConfigMaskBottomY();
            this.displayName = settingsScreen.configOptionContains(config) ? StyledText.fromString(String.valueOf(class_124.field_1073) + config.getDisplayName()) : StyledText.fromString(config.getDisplayName());
        } else if (screen instanceof OverlaySelectionScreen) {
            OverlaySelectionScreen overlaySelectionScreen = (OverlaySelectionScreen)screen;
            this.maskTopY = overlaySelectionScreen.getConfigMaskTopY();
            this.maskBottomY = overlaySelectionScreen.getConfigMaskBottomY();
            this.displayName = overlaySelectionScreen.configOptionContains(config) ? StyledText.fromString(String.valueOf(class_124.field_1073) + config.getDisplayName()) : StyledText.fromString(config.getDisplayName());
        } else {
            this.maskTopY = 0;
            this.maskBottomY = McUtils.screen().field_22790;
            this.displayName = StyledText.fromString(config.getDisplayName());
        }
        this.overlay = overlay;
        this.configOptionElement = this.getWidgetFromConfig(config);
        this.resetButton = new ResetButton(config, () -> {
            this.configOptionElement = this.getWidgetFromConfig(config);
        }, x + width - 40, this.getRenderY(), this.maskTopY, this.maskBottomY);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.resetButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderDisplayName(poseStack);
        RenderUtils.drawLine(poseStack, CommonColors.GRAY, this.method_46426(), this.method_46427() + this.field_22759, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0.0f, 1.0f);
        this.configOptionElement.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderDisplayName(class_4587 poseStack) {
        FontRenderer.getInstance().renderScrollingText(poseStack, this.displayName, this.getRenderX(), this.method_46427() + 3, this.field_22758 - 3, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 0.8f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        class_437 class_4372 = McUtils.screen();
        if (class_4372 instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)class_4372;
            bookSettingsScreen.changesMade();
        }
        return this.resetButton.method_25402(mouseX, mouseY, button) || this.configOptionElement.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        return this.configOptionElement.method_25403(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        return this.configOptionElement.method_25406(mouseX, mouseY, button) || super.method_25406(mouseX, mouseY, button);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.configOptionElement.method_46419(this.getRenderY());
        this.resetButton.method_46419(this.getRenderY());
    }

    public void method_25306() {
    }

    private int getRenderY() {
        return this.method_46427() + 19;
    }

    private int getRenderX() {
        return this.method_46426() + 3;
    }

    private <E extends Enum<E>> class_339 getWidgetFromConfig(Config<?> configOption) {
        if (this.overlay != null && this.screen != null && (configOption.getType().equals(OverlayPosition.class) || configOption.getType().equals(OverlaySize.class) || configOption.getType().equals(HorizontalAlignment.class) || configOption.getType().equals(VerticalAlignment.class))) {
            return new OverlaySettingsWidget(this.getRenderX(), this.getRenderY(), configOption, this.screen, this.maskTopY, this.maskBottomY, this.overlay);
        }
        if (configOption.getType().equals(Boolean.class)) {
            return new BooleanSettingsButton(this.getRenderX(), this.getRenderY(), configOption, this.maskTopY, this.maskBottomY);
        }
        if (configOption.isEnum()) {
            return new EnumSettingsButton<Boolean>(this.getRenderX(), this.getRenderY(), configOption, this.maskTopY, this.maskBottomY);
        }
        if (configOption.getType().equals(CustomColor.class)) {
            return new CustomColorSettingsButton(this.getRenderX(), this.getRenderY(), (Config<CustomColor>)configOption, (TextboxScreen)this.screen, this.maskTopY, this.maskBottomY);
        }
        return new TextInputBoxSettingsWidget<Boolean>(this.getRenderX(), this.getRenderY(), configOption, (TextboxScreen)this.screen, this.maskTopY, this.maskBottomY);
    }
}

