/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.statistics.widgets;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.statistics.WynntilsStatisticsScreen;
import com.wynntils.services.statistics.type.StatisticEntry;
import com.wynntils.services.statistics.type.StatisticKind;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class StatisticButton
extends WynntilsButton
implements TooltipProvider {
    private static final CustomColor BUTTON_COLOR = new CustomColor(181, 174, 151);
    private static final CustomColor BUTTON_COLOR_HOVERED = new CustomColor(121, 116, 101);
    private static final CustomColor TRACKED_BUTTON_COLOR = new CustomColor(176, 197, 148);
    private static final CustomColor TRACKED_BUTTON_COLOR_HOVERED = new CustomColor(126, 211, 106);
    private final StatisticKind statistic;
    private final WynntilsStatisticsScreen screen;

    public StatisticButton(int x, int y, int width, int height, StatisticKind statistic, WynntilsStatisticsScreen screen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Statistics Button"));
        this.statistic = statistic;
        this.screen = screen;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        CustomColor backgroundColor = this.getButtonBackgroundColor();
        RenderUtils.drawRect(poseStack, backgroundColor, this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.statistic.getName()), this.method_46426() + 2, this.method_46427() + 1, this.field_22758 - 3, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.0f);
    }

    private CustomColor getButtonBackgroundColor() {
        if (this.isSelected()) {
            return this.field_22762 ? TRACKED_BUTTON_COLOR_HOVERED : TRACKED_BUTTON_COLOR;
        }
        return this.field_22762 ? BUTTON_COLOR_HOVERED : BUTTON_COLOR;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isSelected()) {
                this.screen.setHighlightedStatisticKind(null);
            } else {
                this.screen.setHighlightedStatisticKind(this.statistic);
            }
            return true;
        }
        if (KeyboardUtils.isShiftDown() && button == 2) {
            if (((Boolean)Services.Statistics.screenOverallMode.get()).booleanValue()) {
                Services.Statistics.resetStatisticOverall(this.statistic);
            } else {
                Services.Statistics.resetStatisticForCharacter(this.statistic);
            }
            this.screen.reloadElements();
            return true;
        }
        return true;
    }

    public void method_25306() {
    }

    @Override
    public List<class_2561> getTooltipLines() {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        StatisticEntry entry = (Boolean)Services.Statistics.screenOverallMode.get() != false ? Services.Statistics.getOverallStatistic(this.statistic) : Services.Statistics.getStatistic(this.statistic);
        lines.add((class_2561)class_2561.method_43470((String)this.statistic.getName()).method_27692(class_124.field_1067));
        lines.add((class_2561)class_2561.method_43469((String)"screens.wynntils.statistics.total", (Object[])new Object[]{this.statistic.getFormattedValue(entry.total())}));
        lines.add((class_2561)class_2561.method_43469((String)"screens.wynntils.statistics.lastModified", (Object[])new Object[]{entry.lastModified() == 0L ? "-" : StringUtils.formatDateTime(entry.lastModified())}));
        lines.add((class_2561)class_2561.method_43473());
        if (this.isSelected()) {
            lines.add((class_2561)class_2561.method_43471((String)"screens.wynntils.statistics.leftClickToUnselect").method_27692(class_124.field_1067).method_27692(class_124.field_1054));
        } else {
            lines.add((class_2561)class_2561.method_43471((String)"screens.wynntils.statistics.leftClickToView").method_27692(class_124.field_1067).method_27692(class_124.field_1060));
        }
        lines.add((class_2561)((Boolean)Services.Statistics.screenOverallMode.get() != false ? class_2561.method_43471((String)"screens.wynntils.statistics.shiftMiddleClickToResetOverall") : class_2561.method_43471((String)"screens.wynntils.statistics.shiftMiddleClickToResetCurrent")).method_27692(class_124.field_1067).method_27692(class_124.field_1061));
        return ComponentUtils.wrapTooltips(lines, 250);
    }

    private boolean isSelected() {
        return this.screen.getHighlightedStatisticKind() == this.statistic;
    }
}

