/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.ui.CustomTerritoryManagementScreenFeature;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.models.items.items.gui.TerritoryItem;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.base.widgets.ItemFilterUIButton;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.territorymanagement.TerritoryManagementHolder;
import com.wynntils.screens.territorymanagement.widgets.GuildOverallProductionWidget;
import com.wynntils.screens.territorymanagement.widgets.TerritoryApplyLoadoutButton;
import com.wynntils.screens.territorymanagement.widgets.TerritoryHighlightLegendWidget;
import com.wynntils.screens.territorymanagement.widgets.TerritoryWidget;
import com.wynntils.screens.territorymanagement.widgets.quickfilters.TerritoryBonusesQuickFilterWidget;
import com.wynntils.screens.territorymanagement.widgets.quickfilters.TerritoryDefenseQuickFilterWidget;
import com.wynntils.screens.territorymanagement.widgets.quickfilters.TerritoryProducesQuickFilterWidget;
import com.wynntils.screens.territorymanagement.widgets.quickfilters.TerritoryQuickFilterWidget;
import com.wynntils.screens.territorymanagement.widgets.quicksorts.TerritoryDefenseQuickSortWidget;
import com.wynntils.screens.territorymanagement.widgets.quicksorts.TerritoryOverallProductionQuickSortWidget;
import com.wynntils.screens.territorymanagement.widgets.quicksorts.TerritoryQuickSortWidget;
import com.wynntils.screens.territorymanagement.widgets.quicksorts.TerritoryTreasuryQuickSortWidget;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;

public class TerritoryManagementScreen
extends WynntilsScreen
implements WrappedScreen {
    private static final Pair<Integer, Integer> RENDER_AREA_POSITION = new Pair<Integer, Integer>(9, 16);
    private static final Pair<Integer, Integer> RENDER_AREA_SIZE = new Pair<Integer, Integer>(221, 110);
    private static final int TERRITORY_SIZE = 20;
    private static final int TERRITORIES_PER_ROW = RENDER_AREA_SIZE.a() / 20;
    private static final int BACK_BUTTON_SLOT = 18;
    private static final int APPLY_BUTTON_SLOT = 0;
    private static final int LOADOUT_BUTTON_SLOT = 36;
    private static final int QUICK_FILTER_WIDTH = 150;
    private List<Pair<class_1799, TerritoryItem>> territoryItems = new ArrayList<Pair<class_1799, TerritoryItem>>();
    private final List<class_339> renderAreaWidgets = new ArrayList<class_339>();
    private final List<TerritoryQuickFilterWidget> quickFilters = new ArrayList<TerritoryQuickFilterWidget>();
    private final List<TerritoryQuickSortWidget> quickSorts = new ArrayList<TerritoryQuickSortWidget>();
    private ItemSearchWidget itemSearchWidget;
    private float scrollOffset = 0.0f;
    private boolean draggingScroll = false;
    private final WrappedScreenInfo wrappedScreenInfo;
    private final TerritoryManagementHolder holder;

    public TerritoryManagementScreen(WrappedScreenInfo wrappedScreenInfo, TerritoryManagementHolder holder) {
        super((class_2561)class_2561.method_43470((String)"Territory Management"));
        this.wrappedScreenInfo = wrappedScreenInfo;
        this.holder = holder;
    }

    @Override
    public WrappedScreenInfo getWrappedScreenInfo() {
        return this.wrappedScreenInfo;
    }

    @Override
    protected void doInit() {
        ItemSearchWidget oldWidget = this.itemSearchWidget;
        this.itemSearchWidget = new ItemSearchWidget(this.getRenderX(), this.getRenderY() - 20, Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() - 25, 20, List.of(ItemProviderType.TERRITORY), true, q -> this.populateRenderAreaWidgets(), this);
        this.method_37063((class_364)this.itemSearchWidget);
        this.itemSearchWidget.setTextBoxInput(oldWidget == null ? "" : oldWidget.getSearchQuery().queryString());
        this.method_37063((class_364)new ItemFilterUIButton(this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() - 20, this.getRenderY() - 20, this.itemSearchWidget, this, true, List.of(ItemProviderType.TERRITORY)));
        this.method_37063((class_364)new TerritoryHighlightLegendWidget(this.getRenderX(), this.getRenderY() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.height() + 5, Texture.TERRITORY_MANAGEMENT_BACKGROUND.width(), 110, this.holder));
        this.method_37060((class_4068)new GuildOverallProductionWidget(this.getRenderX() - 190, this.getRenderY() + 10, 200, 150, this.holder));
        this.method_37063((class_364)new BasicTexturedButton(this.getRenderX() - 20, this.getRenderY() + 5, Texture.ARROW_LEFT_ICON.width(), Texture.ARROW_LEFT_ICON.height(), Texture.ARROW_LEFT_ICON, button -> ContainerUtils.clickOnSlot(18, this.wrappedScreenInfo.containerId(), button, (List<class_1799>)this.wrappedScreenInfo.containerMenu().method_7602()), List.of(class_2561.method_43471((String)"gui.back").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067})), false));
        this.method_37063((class_364)new BasicTexturedButton(this.getRenderX() - 20, this.getRenderY() + 75, Texture.DEFENSE_FILTER_ICON.width(), Texture.DEFENSE_FILTER_ICON.height(), Texture.DEFENSE_FILTER_ICON, button -> {
            Storage<Boolean> screenTerritoryProductionTooltip;
            screenTerritoryProductionTooltip.store((Boolean)(screenTerritoryProductionTooltip = Managers.Feature.getFeatureInstance(CustomTerritoryManagementScreenFeature.class).screenTerritoryProductionTooltip).get() == false);
        }, List.of(class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.disableTerritoryProductionTooltip").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.territoryProductionHelper").method_27692(class_124.field_1080)), false));
        this.method_37063((class_364)new BasicTexturedButton(this.getRenderX() - 17, this.getRenderY() + 95, Texture.HELP_ICON.width(), Texture.HELP_ICON.height(), Texture.HELP_ICON, button -> {
            Storage<Boolean> screenHighlightLegend;
            screenHighlightLegend.store((Boolean)(screenHighlightLegend = Managers.Feature.getFeatureInstance(CustomTerritoryManagementScreenFeature.class).screenHighlightLegend).get() == false);
        }, List.of(class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.disableHighlightLegend").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067})), false));
        if (!this.holder.isSelectionMode()) {
            this.method_37063((class_364)new BasicTexturedButton(this.getRenderX() - 20, this.getRenderY() + 115, Texture.TERRITORY_LOADOUT.width(), Texture.TERRITORY_LOADOUT.height(), Texture.TERRITORY_LOADOUT, button -> ContainerUtils.clickOnSlot(36, this.wrappedScreenInfo.containerId(), button, (List<class_1799>)this.wrappedScreenInfo.containerMenu().method_7602()), List.of(class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.loadouts").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43473(), class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.loadouts.description").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.loadouts.clickToOpen").method_27692(class_124.field_1060))));
        } else {
            this.method_37063((class_364)new TerritoryApplyLoadoutButton(this.getRenderX() - 20, this.getRenderY() + 115, Texture.CHECKMARK_YELLOW.width(), Texture.CHECKMARK_YELLOW.height(), this.holder::getApplyButtonTexture, button -> ContainerUtils.clickOnSlot(0, this.wrappedScreenInfo.containerId(), button, (List<class_1799>)this.wrappedScreenInfo.containerMenu().method_7602()), List.of(class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.applySelection").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43473(), class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.applySelection.description").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.applySelection.clickToConfirm").method_27692(class_124.field_1060))));
        }
        this.quickFilters.clear();
        this.quickFilters.add(new TerritoryBonusesQuickFilterWidget(this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() + 5, this.getRenderY() + 20, 150, 10, this));
        this.quickFilters.add(new TerritoryDefenseQuickFilterWidget(this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() + 5, this.getRenderY() + 35, 150, 10, this));
        this.quickFilters.add(new TerritoryProducesQuickFilterWidget(this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() + 5, this.getRenderY() + 50, 150, 10, this));
        this.quickSorts.clear();
        this.quickSorts.add(new TerritoryTreasuryQuickSortWidget(this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() + 5, this.getRenderY() + 85, 150, 10, this));
        this.quickSorts.add(new TerritoryDefenseQuickSortWidget(this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() + 5, this.getRenderY() + 100, 150, 10, this));
        this.quickSorts.add(new TerritoryOverallProductionQuickSortWidget(this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() + 5, this.getRenderY() + 115, 150, 10, this));
        this.updateTerritoryItems();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.TERRITORY_MANAGEMENT_BACKGROUND, this.getRenderX(), this.getRenderY());
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.TERRITORY_SIDEBAR, this.getRenderX() - 22, this.getRenderY());
        FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromComponent(this.wrappedScreenInfo.screen().method_25440()), this.getRenderX() + 8, this.getRenderY() + 9, CommonColors.TITLE_GRAY, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NONE);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollButton(guiGraphics);
        this.renderQuickFiltersAndSorts(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderWidgets(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.enableScissor(guiGraphics, this.getRenderX() + RENDER_AREA_POSITION.a(), this.getRenderY() + RENDER_AREA_POSITION.b(), RENDER_AREA_SIZE.a(), RENDER_AREA_SIZE.b());
        for (class_339 widget2 : this.renderAreaWidgets) {
            widget2.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        this.field_33816.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    private void renderScrollButton(class_332 guiGraphics) {
        float renderY = MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), this.getRenderY() + RENDER_AREA_POSITION.b(), this.getRenderY() + RENDER_AREA_POSITION.b() + RENDER_AREA_SIZE.b());
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.SCROLLBAR_BUTTON, (float)(this.getRenderX() + RENDER_AREA_POSITION.a() + RENDER_AREA_SIZE.a()) + 10.0f - (float)Texture.SCROLL_BUTTON.width() / 2.0f, renderY - (float)Texture.SCROLLBAR_BUTTON.height() / 2.0f);
    }

    private void renderQuickFiltersAndSorts(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int xOffset = this.getRenderX() + Texture.TERRITORY_MANAGEMENT_BACKGROUND.width() + 5;
        RenderUtils.drawRect(guiGraphics.method_51448(), CommonColors.BLACK.withAlpha(80), xOffset, this.getRenderY(), 0.0f, 150.0f, Texture.TERRITORY_MANAGEMENT_BACKGROUND.height());
        FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.filters")), (float)xOffset, (float)(150 + xOffset), (float)(5 + this.getRenderY()), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, TextShadow.OUTLINE);
        FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_43471((String)"feature.wynntils.customTerritoryManagementScreen.sorts")), (float)xOffset, (float)(150 + xOffset), (float)(70 + this.getRenderY()), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, TextShadow.OUTLINE);
        for (TerritoryQuickFilterWidget quickFilter : this.quickFilters) {
            quickFilter.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        for (TerritoryQuickSortWidget quickSort : this.quickSorts) {
            quickSort.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        class_339 hoveredWidget = this.getHoveredWidget(mouseX, mouseY);
        if (hoveredWidget == null) {
            return;
        }
        if (!(hoveredWidget instanceof TooltipProvider)) {
            return;
        }
        TooltipProvider tooltipProvider = (TooltipProvider)hoveredWidget;
        List<class_2561> tooltipLines = tooltipProvider.getTooltipLines();
        if (tooltipLines.isEmpty()) {
            return;
        }
        guiGraphics.method_51434(FontRenderer.getInstance().getFont(), tooltipLines, mouseX, mouseY);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)(this.getRenderX() + RENDER_AREA_POSITION.a()) && mouseX <= (double)(this.getRenderX() + RENDER_AREA_POSITION.a() + RENDER_AREA_SIZE.a()) && mouseY >= (double)(this.getRenderY() + RENDER_AREA_POSITION.b()) && mouseY <= (double)(this.getRenderY() + RENDER_AREA_POSITION.b() + RENDER_AREA_SIZE.b())) {
            for (class_339 widget : this.renderAreaWidgets) {
                if (!widget.method_25405(mouseX, mouseY + (double)this.scrollOffset)) continue;
                return widget.method_25402(mouseX, mouseY + (double)this.scrollOffset, button);
            }
        }
        for (TerritoryQuickFilterWidget quickFilter : this.quickFilters) {
            if (!quickFilter.method_25405(mouseX, mouseY)) continue;
            return quickFilter.method_25402(mouseX, mouseY, button);
        }
        for (TerritoryQuickSortWidget quickSort : this.quickSorts) {
            if (!quickSort.method_25405(mouseX, mouseY)) continue;
            return quickSort.method_25402(mouseX, mouseY, button);
        }
        float scrollX = (float)(this.getRenderX() + RENDER_AREA_POSITION.a() + RENDER_AREA_SIZE.a()) + 10.0f - (float)Texture.SCROLL_BUTTON.width() / 2.0f;
        float scrollY = MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), this.getRenderY() + RENDER_AREA_POSITION.b(), this.getRenderY() + RENDER_AREA_POSITION.b() + RENDER_AREA_SIZE.b());
        if (mouseX >= (double)scrollX && mouseX <= (double)(scrollX + (float)Texture.SCROLL_BUTTON.width()) && mouseY >= (double)(scrollY - (float)Texture.SCROLL_BUTTON.height() / 2.0f) && mouseY <= (double)(scrollY + (float)Texture.SCROLL_BUTTON.height() / 2.0f)) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollOffset((float)((double)this.scrollOffset - Math.signum(scrollY) * 10.0));
        this.scrollAreaWidgets(this.scrollOffset);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            float newScrollOffset = MathUtils.map((float)mouseY, this.getRenderY() + RENDER_AREA_POSITION.b(), this.getRenderY() + RENDER_AREA_POSITION.b() + RENDER_AREA_SIZE.b(), 0.0f, this.getMaxScrollOffset());
            this.setScrollOffset(newScrollOffset);
            this.scrollAreaWidgets(this.scrollOffset);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void updateTerritoryItems() {
        this.territoryItems = this.holder.territoryItems().stream().toList();
        this.populateRenderAreaWidgets();
        this.scrollOffset = Math.min((float)this.getMaxScrollOffset(), this.scrollOffset);
    }

    public void updateSearchFromQuickFilters() {
        this.itemSearchWidget.setTextBoxInput(Stream.concat(this.quickFilters.stream().map(TerritoryQuickFilterWidget::getItemSearchQuery), this.quickSorts.stream().map(TerritoryQuickSortWidget::getItemSearchQuery)).collect(Collectors.joining(" ")).trim().replaceAll("\\s+", " "));
    }

    private void populateRenderAreaWidgets() {
        List<Pair> filteredItems = Services.ItemFilter.filterAndSort(this.itemSearchWidget.getSearchQuery(), this.territoryItems.stream().map(Pair::a).toList()).stream().map(item -> Pair.of(item, Models.Item.asWynnItem((class_1799)item, TerritoryItem.class).orElseThrow())).toList();
        this.renderAreaWidgets.clear();
        int x = this.getRenderX() + RENDER_AREA_POSITION.a();
        int y = this.getRenderY() + RENDER_AREA_POSITION.b();
        int xOffset = (RENDER_AREA_SIZE.a() - TERRITORIES_PER_ROW * 20) / 2;
        int yOffset = 0;
        for (Pair territoryItemPair : filteredItems) {
            this.renderAreaWidgets.add(new TerritoryWidget(x + xOffset, y + yOffset, 20, 20, this.holder, this.holder.getTerritoryColor((TerritoryItem)territoryItemPair.b()), (class_1799)territoryItemPair.a(), (TerritoryItem)territoryItemPair.b()));
            if ((xOffset += 20) < 20 * TERRITORIES_PER_ROW) continue;
            xOffset = (RENDER_AREA_SIZE.a() - TERRITORIES_PER_ROW * 20) / 2;
            yOffset += 20;
        }
        this.scrollAreaWidgets(this.scrollOffset);
    }

    private class_339 getHoveredWidget(int mouseX, int mouseY) {
        for (class_339 widget : this.renderAreaWidgets) {
            if (!widget.method_25405((double)mouseX, (double)mouseY) || mouseY < this.getRenderY() + RENDER_AREA_POSITION.b() || mouseY > this.getRenderY() + RENDER_AREA_POSITION.b() + RENDER_AREA_SIZE.b()) continue;
            return widget;
        }
        for (class_364 child : this.field_22786) {
            if (!(child instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)child;
            class_339 widget = (class_339)child;
            if (!widget.method_25405((double)mouseX, (double)mouseY)) continue;
            return widget;
        }
        return null;
    }

    private void scrollAreaWidgets(float newOffset) {
        this.scrollOffset = newOffset;
        int y = this.getRenderY() + RENDER_AREA_POSITION.b();
        int xOffset = (RENDER_AREA_SIZE.a() - TERRITORIES_PER_ROW * 20) / 2;
        int yOffset = 0;
        for (class_339 areaWidget : this.renderAreaWidgets) {
            int newY = (int)((float)(y + yOffset) - this.scrollOffset);
            areaWidget.method_46419(newY);
            if ((xOffset += 20) < 20 * TERRITORIES_PER_ROW) continue;
            xOffset = (RENDER_AREA_SIZE.a() - TERRITORIES_PER_ROW * 20) / 2;
            yOffset += 20;
        }
    }

    private void setScrollOffset(float scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.scrollOffset = Math.max(0.0f, this.scrollOffset);
        this.scrollOffset = Math.min((float)this.getMaxScrollOffset(), this.scrollOffset);
    }

    private int getMaxScrollOffset() {
        int totalHeight = 20 * ((this.renderAreaWidgets.size() + TERRITORIES_PER_ROW - 1) / TERRITORIES_PER_ROW);
        return Math.max(0, totalHeight - RENDER_AREA_SIZE.b());
    }

    private int getRenderX() {
        return (this.field_22789 - Texture.TERRITORY_MANAGEMENT_BACKGROUND.width()) / 2;
    }

    private int getRenderY() {
        return (this.field_22790 - Texture.TERRITORY_MANAGEMENT_BACKGROUND.height()) / 2;
    }
}

