/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.update;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.changelog.ChangelogScreen;
import com.wynntils.services.athena.type.UpdateResult;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_7919;

public final class UpdateScreen
extends WynntilsScreen {
    private final class_437 titleScreen;
    private final class_642 serverData;
    private class_4185 updateButton;
    private class_4185 updateNowButton;
    private class_4185 ignoreNowButton;
    private class_4185 ignoreUpdateButton;
    private class_4185 changelogButton;
    private class_4185 titleScreenButton;
    private UpdateResult updateResult;
    private CompletionTrigger completionTrigger = null;
    private long completionFinish = 0L;

    private UpdateScreen(class_642 serverData, class_437 titleScreen) {
        super((class_2561)class_2561.method_43470((String)"Update Screen"));
        this.serverData = serverData;
        this.titleScreen = titleScreen;
    }

    public static class_437 create(class_642 serverData, class_437 titleScreen) {
        return new UpdateScreen(serverData, titleScreen);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.updateButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.update.update"), button -> this.downloadUpdate(false)).method_46433(this.field_22789 / 2 - 150, this.field_22790 / 2 + 40).method_46437(140, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.update.updateTooltip"))).method_46431();
        this.method_37063((class_364)this.updateButton);
        this.updateNowButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.update.updateExit"), button -> this.downloadUpdate(true)).method_46433(this.field_22789 / 2 + 10, this.field_22790 / 2 + 40).method_46437(140, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.update.updateExitTooltip"))).method_46431();
        this.method_37063((class_364)this.updateNowButton);
        this.ignoreNowButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.update.ignoreNow"), button -> this.ignoreUpdate(false)).method_46433(this.field_22789 / 2 - 150, this.field_22790 / 2 + 70).method_46437(140, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.update.ignoreNowTooltip"))).method_46431();
        this.method_37063((class_364)this.ignoreNowButton);
        this.ignoreUpdateButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.update.ignorePermenantly"), button -> this.ignoreUpdate(true)).method_46433(this.field_22789 / 2 + 10, this.field_22790 / 2 + 70).method_46437(140, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43469((String)"screens.wynntils.update.ignorePermenantlyTooltip", (Object[])new Object[]{Services.Update.getModUpdateInfo().version()}))).method_46431();
        this.method_37063((class_364)this.ignoreUpdateButton);
        this.changelogButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.update.changelog"), button -> this.showChangelog()).method_46433(this.field_22789 / 2 - 150, this.field_22790 / 2 + 100).method_46437(140, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43469((String)"screens.wynntils.update.changelogTooltip", (Object[])new Object[]{WynntilsMod.getVersion(), Services.Update.getModUpdateInfo().version()}))).method_46431();
        this.method_37063((class_364)this.changelogButton);
        this.titleScreenButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.update.titleScreen"), button -> this.method_25419()).method_46433(this.field_22789 / 2 + 10, this.field_22790 / 2 + 100).method_46437(140, 20).method_46431();
        this.method_37063((class_364)this.titleScreenButton);
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43469((String)"screens.wynntils.update.title", (Object[])new Object[]{Services.Update.getModUpdateInfo().version()}).method_27692(class_124.field_1073)), (float)this.field_22789 / 2.0f, 30.0f, CommonColors.DARK_AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f);
        if (Services.Update.getUpdateProgress() != -1.0f) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.update.downloading")), (float)this.field_22789 / 2.0f, 60.0f, CommonColors.AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((int)(Services.Update.getUpdateProgress() * 100.0f) + "%"), (float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f - (float)Texture.UNIVERSAL_BAR.height(), CommonColors.LIGHT_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            BufferedRenderUtils.drawColoredProgressBar(poseStack, (class_4597)guiGraphics.field_44658, Texture.UNIVERSAL_BAR, CommonColors.LIGHT_GREEN, (float)this.field_22789 / 2.0f - (float)Texture.UNIVERSAL_BAR.width(), (float)this.field_22790 / 2.0f - (float)UniversalTexture.A.getHeight(), (float)this.field_22789 / 2.0f + (float)Texture.UNIVERSAL_BAR.width(), (float)this.field_22790 / 2.0f + (float)UniversalTexture.A.getHeight(), 0, UniversalTexture.A.getTextureY1(), Texture.UNIVERSAL_BAR.width(), UniversalTexture.A.getTextureY2(), Services.Update.getUpdateProgress());
            return;
        }
        if (this.updateResult != null) {
            if (this.updateResult == UpdateResult.SUCCESSFUL) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.update.downloaded")), (float)this.field_22789 / 2.0f, 60.0f, CommonColors.GREEN, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
                if (this.completionTrigger == CompletionTrigger.CONNECT) {
                    FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43469((String)"screens.wynntils.update.connecting", (Object[])new Object[]{(int)Math.ceil((float)(this.completionFinish - System.currentTimeMillis()) / 1000.0f)})), (float)this.field_22789 / 2.0f, 100.0f, CommonColors.AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
                } else {
                    FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43469((String)"screens.wynntils.update.exiting", (Object[])new Object[]{(int)Math.ceil((float)(this.completionFinish - System.currentTimeMillis()) / 1000.0f)})), (float)this.field_22789 / 2.0f, 100.0f, CommonColors.AQUA, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
                }
            } else {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)this.updateResult.getMessage()), (float)this.field_22789 / 2.0f, 60.0f, CommonColors.RED, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
            }
            return;
        }
        if (this.completionTrigger != null) {
            return;
        }
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.update.description")), (float)this.field_22789 / 2.0f - 200.0f, (float)this.field_22789 / 2.0f + 200.0f, 60.0f, 120.0f, 400.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.5f);
    }

    private void downloadUpdate(boolean exit) {
        this.completionTrigger = exit ? CompletionTrigger.EXIT : CompletionTrigger.CONNECT;
        Services.Update.setHasPromptedUpdate(true);
        this.toggleButtons(false);
        Services.Update.tryUpdate().thenAccept(result -> {
            if (result == UpdateResult.SUCCESSFUL) {
                this.completionFinish = System.currentTimeMillis() + 3000L;
                Executors.newSingleThreadScheduledExecutor().schedule(() -> McUtils.mc().execute(() -> {
                    if (exit) {
                        System.exit(0);
                    } else {
                        this.connectToServer();
                    }
                }), 3000L, TimeUnit.MILLISECONDS);
            } else {
                this.toggleButtons(true);
            }
            this.updateResult = result;
        });
    }

    private void ignoreUpdate(boolean ignorePermenantly) {
        if (ignorePermenantly) {
            Services.Update.ignoredUpdate.store(Services.Update.getModUpdateInfo().version());
        }
        Services.Update.setHasPromptedUpdate(true);
        this.connectToServer();
    }

    private void showChangelog() {
        Services.Update.getChangelog(WynntilsMod.getVersion(), Services.Update.getModUpdateInfo().version(), false).thenAccept(changelog -> {
            if (changelog == null || changelog.isEmpty()) {
                this.changelogButton.method_25355((class_2561)class_2561.method_43471((String)"screens.wynntils.update.changelog").method_27692(class_124.field_1061));
                this.changelogButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.update.changelogFailed")));
                return;
            }
            Managers.TickScheduler.scheduleNextTick(() -> McUtils.setScreen(ChangelogScreen.create(changelog, this)));
        });
    }

    private void connectToServer() {
        class_412.method_36877((class_437)this.titleScreen, (class_310)McUtils.mc(), (class_639)class_639.method_2950((String)this.serverData.field_3761), (class_642)this.serverData, (boolean)false, null);
    }

    private void toggleButtons(boolean active) {
        this.updateButton.field_22763 = active;
        this.updateNowButton.field_22763 = active;
        this.ignoreNowButton.field_22763 = active;
        this.ignoreUpdateButton.field_22763 = active;
        this.changelogButton.field_22763 = active;
        this.titleScreenButton.field_22763 = active;
    }

    private static enum CompletionTrigger {
        CONNECT,
        EXIT;

    }
}

