/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.cosmetics;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.features.embellishments.WynntilsCosmeticsFeature;
import com.wynntils.models.players.WynntilsUser;
import com.wynntils.models.players.type.CosmeticInfo;
import com.wynntils.services.cosmetics.type.WynntilsCapeLayer;
import com.wynntils.services.cosmetics.type.WynntilsElytraLayer;
import com.wynntils.services.cosmetics.type.WynntilsLayer;
import com.wynntils.utils.mc.McUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.class_10055;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_922;

public class CosmeticsService
extends Service {
    private static final BiFunction<class_922<class_742, class_10055, class_591>, class_5617.class_5618, WynntilsLayer> CAPE_LAYER = (playerRenderer, renderProviderContext) -> new WynntilsCapeLayer((class_3883<class_10055, class_591>)playerRenderer, (class_5617.class_5618)renderProviderContext);
    private static final BiFunction<class_922<class_742, class_10055, class_591>, class_5617.class_5618, WynntilsLayer> ELYTRA_LAYER = (playerRenderer, renderProviderContext) -> new WynntilsElytraLayer((class_3883<class_10055, class_591>)playerRenderer, (class_5617.class_5618)renderProviderContext);
    private static final List<BiFunction<class_922<class_742, class_10055, class_591>, class_5617.class_5618, WynntilsLayer>> REGISTERED_LAYERS = List.of(CAPE_LAYER, ELYTRA_LAYER);
    private final Map<UUID, class_2960[]> cosmeticTextures = new ConcurrentHashMap<UUID, class_2960[]>();

    public CosmeticsService() {
        super(List.of());
    }

    public static List<BiFunction<class_922<class_742, class_10055, class_591>, class_5617.class_5618, WynntilsLayer>> getRegisteredLayers() {
        return REGISTERED_LAYERS;
    }

    public boolean shouldRenderCape(class_1657 player, boolean elytra) {
        if (player.method_5767() || !player.method_7348(class_1664.field_7559)) {
            return false;
        }
        if (Models.Player.getWynntilsUser(player) == null || this.getUserCosmeticTexture(player) == null) {
            return false;
        }
        if (McUtils.player().method_5779((class_1297)player) && !((Boolean)Managers.Feature.getFeatureInstance(WynntilsCosmeticsFeature.class).renderOwnCape.get()).booleanValue()) {
            return false;
        }
        CosmeticInfo cosmetics = Models.Player.getWynntilsUser(player).cosmetics();
        return elytra ? cosmetics.hasElytra() : cosmetics.hasCape();
    }

    public class_2960 getCapeTexture(class_1657 player) {
        class_2960[] textures = this.getUserCosmeticTexture(player);
        if (textures == null) {
            return null;
        }
        int frames = textures.length;
        if (frames == 1) {
            return textures[0];
        }
        double percentage = (double)(System.currentTimeMillis() % 2000L) / 2000.0;
        int currentFrame = (int)((double)frames * percentage);
        return textures[currentFrame];
    }

    public void loadCosmeticTextures(UUID uuid, WynntilsUser user) {
        try {
            if (user.cosmetics().texture() == null || user.cosmetics().texture().isEmpty()) {
                return;
            }
            if (this.cosmeticTextures.containsKey(uuid)) {
                return;
            }
            byte[] textureBytes = Base64.getDecoder().decode(user.cosmetics().texture());
            ByteArrayInputStream byteStream = new ByteArrayInputStream(textureBytes);
            class_1011 image = class_1011.method_4309((InputStream)byteStream);
            int frames = image.method_4323() * 2 / image.method_4307();
            int frameHeight = image.method_4323() / frames;
            class_2960[] locations = new class_2960[frames];
            String baseLocation = "wynntils:capes/" + uuid.toString().replace("-", "");
            if (frames == 1) {
                locations[0] = class_2960.method_60654((String)baseLocation);
                McUtils.mc().method_1531().method_4616(locations[0], (class_1044)new class_1043(image));
            } else {
                for (int i = 0; i < frames; ++i) {
                    class_1011 frame = new class_1011(frameHeight * 2, frameHeight, false);
                    image.method_47594(frame, 0, frameHeight * i, 0, 0, frameHeight * 2, frameHeight, false, false);
                    locations[i] = class_2960.method_60654((String)(baseLocation + "/" + i));
                    McUtils.mc().method_1531().method_4616(locations[i], (class_1044)new class_1043(frame));
                }
            }
            this.cosmeticTextures.put(uuid, locations);
        }
        catch (IOException e) {
            WynntilsMod.warn("IOException occurred while loading cosmetics for user " + String.valueOf(uuid), e);
        }
    }

    private class_2960[] getUserCosmeticTexture(class_1657 player) {
        return this.cosmeticTextures.getOrDefault(Models.Player.getUserUUID(player), null);
    }
}

