/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.statproviders;

import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.Optional;

public class SkillReqStatProvider
extends ItemStatProvider<Integer> {
    private final Skill skill;

    public SkillReqStatProvider(Skill skill) {
        this.skill = skill;
    }

    @Override
    public String getName() {
        return this.skill.getApiName() + "Req";
    }

    @Override
    public String getDisplayName() {
        return this.skill.getDisplayName() + " Required";
    }

    @Override
    public String getDescription() {
        return this.getTranslation("description", this.skill.getDisplayName());
    }

    @Override
    public Optional<Integer> getValue(WynnItem wynnItem) {
        if (!(wynnItem instanceof GearItem)) {
            return Optional.empty();
        }
        GearItem gearItem = (GearItem)wynnItem;
        return gearItem.getItemInfo().requirements().skills().stream().filter(pair -> pair.key() == this.skill).map(Pair::value).findFirst();
    }

    @Override
    public List<ItemProviderType> getFilterTypes() {
        return List.of(ItemProviderType.GEAR);
    }

    @Override
    public List<String> getAliases() {
        if (this.skill == Skill.DEFENCE) {
            return List.of("defenseReq");
        }
        return super.getAliases();
    }
}

