/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.type;

import com.wynntils.models.items.WynnItem;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class StatProviderFilterMap {
    private final Map<ItemStatProvider<?>, List<StatProviderAndFilterPair>> map = new HashMap();

    public void put(ItemStatProvider<?> statProvider, StatFilter<?> statFilter) {
        this.map.computeIfAbsent(statProvider, k -> new ArrayList()).add(StatProviderAndFilterPair.fromPair(statProvider, statFilter));
    }

    public void put(StatProviderAndFilterPair filter) {
        this.map.computeIfAbsent(filter.statProvider(), k -> new ArrayList()).add(filter);
    }

    public void putAll(ItemStatProvider<?> statProvider, List<StatProviderAndFilterPair> filters) {
        this.map.computeIfAbsent(statProvider, k -> new ArrayList()).addAll(filters);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean matches(WynnItem wynnItem) {
        return this.map.entrySet().stream().allMatch(entry -> ((List)entry.getValue()).stream().anyMatch(pair -> pair.matches(wynnItem)));
    }

    public Map<ItemStatProvider<?>, List<StatProviderAndFilterPair>> entries() {
        return Map.copyOf(this.map);
    }

    public List<StatProviderAndFilterPair> values() {
        return this.map.values().stream().flatMap(Collection::stream).toList();
    }

    public List<StatProviderAndFilterPair> get(ItemStatProvider<?> selectedProvider) {
        return List.copyOf(this.map.getOrDefault(selectedProvider, List.of()));
    }

    public void removeIf(Function<StatProviderAndFilterPair, Boolean> filter) {
        this.map.values().forEach(list -> list.removeIf(filter::apply));
        this.map.entrySet().removeIf((? super E entry) -> ((List)entry.getValue()).isEmpty());
    }

    public boolean containsKey(ItemStatProvider<?> provider) {
        return this.map.containsKey(provider);
    }
}

