/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.leaderboard;

import com.google.gson.JsonElement;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.services.leaderboard.type.LeaderboardBadge;
import com.wynntils.services.leaderboard.type.LeaderboardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LeaderboardService
extends Service {
    private Map<UUID, List<LeaderboardBadge>> leaderboard = new HashMap<UUID, List<LeaderboardBadge>>();

    public LeaderboardService() {
        super(List.of());
    }

    @Override
    public void reloadData() {
        this.updateLeaderboards();
    }

    public List<LeaderboardBadge> getBadges(UUID id) {
        return this.leaderboard.getOrDefault(id, List.of());
    }

    private void updateLeaderboards() {
        this.leaderboard = new HashMap<UUID, List<LeaderboardBadge>>();
        for (LeaderboardType type : LeaderboardType.values()) {
            ApiResponse apiResponse = Managers.Net.callApi(UrlId.DATA_WYNNCRAFT_LEADERBOARD, Map.of("type", type.getKey()));
            apiResponse.handleJsonObject(json -> {
                for (Map.Entry entry : json.entrySet()) {
                    String uuidStr = ((JsonElement)entry.getValue()).getAsJsonObject().get("uuid").getAsString();
                    if (uuidStr.equals("redacted")) continue;
                    UUID uuid = UUID.fromString(uuidStr);
                    List badges = this.leaderboard.getOrDefault(uuid, new ArrayList());
                    badges.add(LeaderboardBadge.from(type, Integer.parseInt((String)entry.getKey())));
                    this.leaderboard.put(uuid, badges);
                }
            });
        }
    }
}

