/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.features.LootrunFeature;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.mc.event.RenderLevelEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.containers.containers.reward.LootChestContainer;
import com.wynntils.services.lootrunpaths.LootrunCompiler;
import com.wynntils.services.lootrunpaths.LootrunPathFileParser;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.LootrunRenderer;
import com.wynntils.services.lootrunpaths.RecordingInformation;
import com.wynntils.services.lootrunpaths.UncompiledLootrunPath;
import com.wynntils.services.lootrunpaths.event.LootrunPathCacheRefreshEvent;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.services.lootrunpaths.type.LootrunSaveResult;
import com.wynntils.services.lootrunpaths.type.LootrunState;
import com.wynntils.services.lootrunpaths.type.LootrunUndoResult;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.PosUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5365;
import net.minecraft.class_746;
import net.neoforged.bus.api.SubscribeEvent;

public final class LootrunPathsService
extends Service {
    public static final File LOOTRUNS = WynntilsMod.getModStorageDir("lootruns");
    private List<LootrunPathInstance> lootrunPathInstanceCache = new ArrayList<LootrunPathInstance>();
    private UncompiledLootrunPath uncompiled = null;
    private LootrunState state = LootrunState.DISABLED;
    private LootrunPathInstance lootrun = null;
    private LootrunPathInstance recordingCompiled = null;
    private UncompiledLootrunPath recording = null;
    private RecordingInformation recordingInformation = null;

    public LootrunPathsService() {
        super(List.of());
        FileUtils.mkdir(LOOTRUNS);
    }

    public LootrunState getState() {
        return this.state;
    }

    public int addNote(class_2561 text) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return 0;
        }
        class_1297 root = McUtils.player().method_5668();
        current.notes().add(new LootrunNote((class_2374)root.method_19538(), text));
        return this.recompileLootrun(true);
    }

    public LootrunPathInstance getCurrentLootrun() {
        return this.lootrun;
    }

    public int recompileLootrun(boolean saveToFile) {
        if (this.recording != null) {
            this.recordingInformation.setDirty(true);
        } else if (this.uncompiled != null) {
            this.lootrun = LootrunCompiler.compile(this.uncompiled, false);
            if (saveToFile && this.uncompiled.file() != null) {
                LootrunSaveResult lootrunSaveResult = this.saveCurrentLootrun(this.uncompiled.file().getName().replace(".json", ""));
                if (lootrunSaveResult == null) {
                    return 0;
                }
                switch (lootrunSaveResult) {
                    case SAVED: {
                        return 1;
                    }
                    case ERROR_SAVING: 
                    case ERROR_ALREADY_EXISTS: {
                        return 0;
                    }
                }
            }
        }
        return 1;
    }

    public void clearCurrentLootrun() {
        this.state = LootrunState.DISABLED;
        this.lootrun = null;
        this.uncompiled = null;
        this.recording = null;
        this.recordingCompiled = null;
        this.recordingInformation = null;
    }

    public void stopRecording() {
        this.state = LootrunState.LOADED;
        this.lootrun = LootrunCompiler.compile(this.recording, false);
        this.uncompiled = this.recording;
        this.recording = null;
        this.recordingCompiled = null;
        this.recordingInformation = null;
    }

    public void startRecording() {
        this.state = LootrunState.RECORDING;
        this.recording = new UncompiledLootrunPath(new LootrunPath(new ArrayList<class_243>()), new HashSet<class_2338>(), new ArrayList<LootrunNote>(), null);
        this.recordingInformation = new RecordingInformation();
    }

    public List<LootrunPathInstance> getLootruns() {
        return this.lootrunPathInstanceCache;
    }

    public void refreshLootrunCache() {
        ArrayList<LootrunPathInstance> lootruns = new ArrayList<LootrunPathInstance>();
        File[] files = LOOTRUNS.listFiles();
        for (File file : files != null ? files : new File[]{}) {
            if (!file.getName().endsWith(".json")) continue;
            try {
                FileReader reader = new FileReader(file, StandardCharsets.UTF_8);
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                UncompiledLootrunPath uncompiled = LootrunPathFileParser.readJson(file, json);
                lootruns.add(LootrunCompiler.compile(uncompiled, false));
            }
            catch (Exception e) {
                WynntilsMod.warn("Could not parse lootrun file.", e);
            }
        }
        this.lootrunPathInstanceCache = lootruns;
        WynntilsMod.postEvent(new LootrunPathCacheRefreshEvent());
    }

    private boolean loadFile(String fileName) {
        String lootrunFileName = fileName + ".json";
        File lootrunFile = new File(LOOTRUNS, lootrunFileName);
        if (lootrunFile.exists()) {
            try {
                FileReader file = new FileReader(lootrunFile, StandardCharsets.UTF_8);
                JsonObject json = JsonParser.parseReader((Reader)file).getAsJsonObject();
                this.uncompiled = LootrunPathFileParser.readJson(lootrunFile, json);
                this.lootrun = LootrunCompiler.compile(this.uncompiled, false);
                this.state = LootrunState.LOADED;
                file.close();
                return true;
            }
            catch (Exception e) {
                WynntilsMod.error("Error when trying to load lootrun file.", e);
                return false;
            }
        }
        return false;
    }

    public void tryLoadLootrun(String fileName) {
        if (this.loadFile(fileName)) {
            class_2374 startingPoint = Services.LootrunPaths.getStartingPoint();
            class_2338 start = PosUtils.newBlockPos(startingPoint);
            McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"service.wynntils.lootrunPaths.lootrunStart", (Object[])new Object[]{start.method_10263(), start.method_10264(), start.method_10260()}).method_27692(class_124.field_1060));
            if (McUtils.mc().field_1690.method_42534().method_41753() == class_5365.field_25429) {
                McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"service.wynntils.lootrunPaths.fabulousWarning").method_27692(class_124.field_1061));
            }
        } else {
            McUtils.sendErrorToClient(class_1074.method_4662((String)"service.wynntils.lootrunPaths.lootrunCouldNotBeLoaded", (Object[])new Object[]{fileName}));
        }
    }

    public LootrunUndoResult tryUndo() {
        class_243 position = McUtils.player().method_19538();
        LootrunPath points = this.recording.path();
        LootrunPath removed = new LootrunPath(new ArrayList<class_243>());
        boolean left = false;
        for (int i = points.points().size() - 1; i >= 0; --i) {
            if (i == 0) {
                if (left) {
                    return LootrunUndoResult.ERROR_STAND_NEAR_POINT;
                }
                return LootrunUndoResult.ERROR_NOT_FAR_ENOUGH;
            }
            if (points.points().get(i).method_1025(position) < 4.0) {
                if (left) {
                    break;
                }
            } else {
                left = true;
            }
            removed.points().add(points.points().get(i));
        }
        points.points().removeAll(removed.points());
        this.recordingInformation.setDirty(true);
        return LootrunUndoResult.SUCCESSFUL;
    }

    public boolean addChest(class_2338 pos) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return false;
        }
        return current.chests().add(pos);
    }

    public boolean removeChest(class_2338 pos) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return false;
        }
        return current.chests().remove(pos);
    }

    public LootrunNote deleteNoteAt(class_2338 pos) {
        UncompiledLootrunPath current = this.getActiveLootrun();
        if (current == null) {
            return null;
        }
        List<LootrunNote> notes = current.notes();
        for (int i = 0; i < notes.size(); ++i) {
            LootrunNote note = notes.get(i);
            if (!pos.equals((Object)PosUtils.newBlockPos(note.position()))) continue;
            return notes.remove(i);
        }
        return null;
    }

    public List<LootrunNote> getCurrentNotes() {
        UncompiledLootrunPath activeLootrun = this.getActiveLootrun();
        if (activeLootrun == null) {
            return List.of();
        }
        return activeLootrun.notes();
    }

    public class_2374 getStartingPoint() {
        UncompiledLootrunPath activeLootrun = this.getActiveLootrun();
        if (activeLootrun == null) {
            return null;
        }
        if (activeLootrun.path() == null || activeLootrun.path().points().isEmpty()) {
            return null;
        }
        return (class_2374)activeLootrun.path().points().getFirst();
    }

    public LootrunSaveResult saveCurrentLootrun(String name) {
        UncompiledLootrunPath activeLootrun = this.getActiveLootrun();
        if (activeLootrun == null) {
            return null;
        }
        File file = new File(LOOTRUNS, name + ".json");
        this.uncompiled = new UncompiledLootrunPath(activeLootrun.path(), activeLootrun.chests(), activeLootrun.notes(), file);
        return LootrunPathFileParser.writeJson(activeLootrun, file);
    }

    @SubscribeEvent
    public void onRenderLastLevel(RenderLevelEvent.Post event) {
        class_4587 poseStack = new class_4587();
        LootrunRenderer.renderLootrun(poseStack, this.lootrun, ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).activePathColor.get()).asInt());
        LootrunRenderer.renderLootrun(poseStack, this.recordingCompiled, ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).recordingPathColor.get()).asInt());
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.InteractAt event) {
        if (this.state != LootrunState.RECORDING) {
            return;
        }
        class_1297 entity = event.getEntityHitResult().method_17782();
        if (entity != null && entity.method_5864() == class_1299.field_6069) {
            this.recordingInformation.setLastChest(entity.method_24515());
        }
    }

    @SubscribeEvent
    public void onOpen(ScreenOpenedEvent.Post event) {
        if (this.state != LootrunState.RECORDING) {
            return;
        }
        if (this.recordingInformation.getLastChest() == null) {
            return;
        }
        if (!(Models.Container.getCurrentContainer() instanceof LootChestContainer)) {
            return;
        }
        this.recording.chests().add(this.recordingInformation.getLastChest());
        this.recordingInformation.setDirty(true);
        this.recordingInformation.setLastChest(null);
    }

    @SubscribeEvent
    public void recordMovement(TickEvent event) {
        if (this.state != LootrunState.RECORDING) {
            return;
        }
        class_746 player = McUtils.player();
        if (player == null) {
            return;
        }
        class_1297 root = player.method_5668();
        class_243 pos = root.method_19538();
        if (this.recordingInformation.getLastLocation() == null || pos.method_1025(this.recordingInformation.getLastLocation()) >= 4.0) {
            this.recording.path().points().add(pos);
            this.recordingInformation.setLastLocation(pos);
            this.recordingInformation.setDirty(true);
        }
        if (this.recordingInformation.isDirty()) {
            this.recordingCompiled = LootrunCompiler.compile(this.recording, true);
            this.recordingInformation.setDirty(false);
        }
    }

    private UncompiledLootrunPath getActiveLootrun() {
        UncompiledLootrunPath instance = null;
        if (this.recording != null) {
            instance = this.recording;
        } else if (this.uncompiled != null) {
            instance = this.uncompiled;
        }
        return instance;
    }
}

