/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map;

import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.BoundingBox;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;

public class MapTexture {
    private final class_1011 texture;
    private final class_2960 mapResource;
    private boolean registered = false;
    private final int x1;
    private final int z1;
    private final int x2;
    private final int z2;
    private final int textureWidth;
    private final int textureHeight;

    public MapTexture(String name, class_1011 texture, int x1, int z1, int x2, int z2) {
        this.texture = texture;
        this.x1 = x1;
        this.z1 = z1;
        this.x2 = x2;
        this.z2 = z2;
        this.textureWidth = texture.method_4307();
        this.textureHeight = texture.method_4323();
        this.mapResource = class_2960.method_60655((String)"wynntils", (String)("/maps/" + name));
        assert (x2 - x1 + 1 == this.textureWidth);
        assert (z2 - z1 + 1 == this.textureHeight);
    }

    public class_2960 resource() {
        if (!this.registered) {
            this.registered = true;
            McUtils.mc().method_1531().method_4616(this.mapResource, (class_1044)new class_1043(this.texture));
        }
        return this.mapResource;
    }

    public float getTextureXPosition(double posX) {
        return (float)(posX - (double)this.x1);
    }

    public float getTextureZPosition(double posZ) {
        return (float)(posZ - (double)this.z1);
    }

    public int getWorldXPosition(double textureX) {
        return (int)Math.round(textureX + (double)this.x1);
    }

    public int getWorldZPosition(double textureY) {
        return (int)Math.round(textureY + (double)this.z1);
    }

    public int getX1() {
        return this.x1;
    }

    public int getZ1() {
        return this.z1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getZ2() {
        return this.z2;
    }

    public BoundingBox getBox() {
        return new BoundingBox(this.x1, this.z1, this.x2, this.z2);
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }
}

