/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.mapdata.providers.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.MalformedJsonException;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.net.Download;
import com.wynntils.services.mapdata.attributes.type.MapIcon;
import com.wynntils.services.mapdata.providers.MapDataProvider;
import com.wynntils.services.mapdata.providers.json.JsonCategory;
import com.wynntils.services.mapdata.providers.json.JsonIcon;
import com.wynntils.services.mapdata.providers.json.JsonMapAttributes;
import com.wynntils.services.mapdata.providers.json.JsonMapLocation;
import com.wynntils.services.mapdata.type.MapCategory;
import com.wynntils.services.mapdata.type.MapFeature;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.JsonUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public final class JsonProvider
implements MapDataProvider {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(MapCategory.class, (Object)new CategoryDeserializer()).registerTypeHierarchyAdapter(MapFeature.class, (Object)new FeatureDeserializer()).registerTypeHierarchyAdapter(MapIcon.class, (Object)new IconDeserializer()).registerTypeHierarchyAdapter(CustomColor.class, (Object)new CustomColor.CustomColorSerializer()).registerTypeAdapterFactory(new EnumUtils.EnumTypeAdapterFactory()).enableComplexMapKeySerialization().create();
    private final int version;
    private final List<MapFeature> features;
    private final List<MapCategory> categories;
    private final List<MapIcon> icons;

    private JsonProvider(int version, List<MapFeature> features, List<MapCategory> categories, List<MapIcon> icons) {
        this.version = version;
        this.features = features;
        this.categories = categories;
        this.icons = icons;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JsonProvider loadBundledResource(String id, String filename) {
        try (InputStream inputStream = WynntilsMod.getModResourceAsStream(filename);){
            JsonProvider jsonProvider;
            try (InputStreamReader targetReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                jsonProvider = (JsonProvider)GSON.fromJson((Reader)targetReader, JsonProvider.class);
            }
            return jsonProvider;
        }
        catch (MalformedJsonException e) {
            McUtils.sendErrorToClient("Error parsing map data for '" + id + "'");
            WynntilsMod.warn("Error parsing map data for '" + id + "'", e);
        }
        catch (IOException e) {
            McUtils.sendErrorToClient("Error reading map data for '" + id + "'");
            WynntilsMod.warn("Error reading map data for '" + id + "'", e);
        }
        catch (Throwable e) {
            McUtils.sendErrorToClient("Error parsing map data for '" + id + "'");
            WynntilsMod.warn("Error parsing map data for '" + id + "'", e);
        }
        return null;
    }

    public static JsonProvider loadLocalFile(String id, File file) {
        block9: {
            JsonProvider jsonProvider;
            FileReader reader = new FileReader(file, StandardCharsets.UTF_8);
            try {
                jsonProvider = (JsonProvider)GSON.fromJson((Reader)reader, JsonProvider.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (MalformedJsonException e) {
                    McUtils.sendErrorToClient("Error parsing map data for '" + id + "'");
                    WynntilsMod.warn("Error parsing map data for '" + id + "'", e);
                    break block9;
                }
                catch (IOException e) {
                    McUtils.sendErrorToClient("Error reading map data for '" + id + "'");
                    WynntilsMod.warn("Error reading map data for '" + id + "'", e);
                    break block9;
                }
                catch (Throwable e) {
                    McUtils.sendErrorToClient("Error parsing map data for '" + id + "'");
                    WynntilsMod.warn("Error parsing map data for '" + id + "'", e);
                }
            }
            ((Reader)reader).close();
            return jsonProvider;
        }
        return null;
    }

    public static void loadOnlineResource(String id, String url, BiConsumer<String, MapDataProvider> registerCallback) {
        Download dl = Managers.Net.download(URI.create(url), id);
        dl.handleReader(reader -> {
            try {
                registerCallback.accept(id, (MapDataProvider)GSON.fromJson(reader, JsonProvider.class));
            }
            catch (Throwable e) {
                McUtils.sendErrorToClient("Error parsing map data for '" + id + "'");
                WynntilsMod.warn("Error parsing map data for '" + id + "'", e);
            }
        }, onError -> {
            McUtils.sendErrorToClient("Error downloading map data for '" + id + "'");
            WynntilsMod.warn("Error occurred while downloading map data for '" + id + "'", onError);
        });
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public Stream<MapFeature> getFeatures() {
        return this.features.stream();
    }

    @Override
    public Stream<MapCategory> getCategories() {
        return this.categories.stream();
    }

    @Override
    public Stream<MapIcon> getIcons() {
        return this.icons.stream();
    }

    private static final class CategoryDeserializer
    implements JsonDeserializer<MapCategory> {
        private CategoryDeserializer() {
        }

        public MapCategory deserialize(JsonElement jsonElement, Type jsonType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            String id = json.get("id").getAsString();
            String name = JsonUtils.getNullableJsonString(json, "name");
            JsonElement attributesJson = json.get("attributes");
            JsonMapAttributes attributes = attributesJson == null ? null : (JsonMapAttributes)GSON.fromJson(attributesJson, JsonMapAttributes.class);
            return new JsonCategory(id, name, attributes);
        }
    }

    private static final class FeatureDeserializer
    implements JsonDeserializer<MapFeature> {
        private FeatureDeserializer() {
        }

        public MapFeature deserialize(JsonElement jsonElement, Type jsonType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            String id = JsonUtils.getNullableJsonString(json, "id");
            String category = JsonUtils.getNullableJsonString(json, "category");
            JsonElement locationJson = json.get("location");
            Location location = (Location)GSON.fromJson(locationJson, Location.class);
            JsonElement attributesJson = json.get("attributes");
            JsonMapAttributes attributes = attributesJson == null ? null : (JsonMapAttributes)GSON.fromJson(attributesJson, JsonMapAttributes.class);
            return new JsonMapLocation(id, category, attributes, location);
        }
    }

    private static final class IconDeserializer
    implements JsonDeserializer<MapIcon> {
        private IconDeserializer() {
        }

        public MapIcon deserialize(JsonElement jsonElement, Type jsonType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            String id = json.get("id").getAsString();
            String base64Texture = json.get("texture").getAsString();
            byte[] texture = Base64.getDecoder().decode(base64Texture);
            try {
                return new JsonIcon(id, texture);
            }
            catch (IOException e) {
                WynntilsMod.warn("Bad icon texture for " + id, e);
                return null;
            }
        }
    }
}

