/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.stopwatch;

import com.wynntils.core.components.Service;
import java.util.List;

public class StopwatchService
extends Service {
    private long startTimeMillis = 0L;
    private long elapsedBeforePause = 0L;
    private boolean running = false;

    public StopwatchService() {
        super(List.of());
    }

    public int getHours() {
        return (int)(this.getElapsedMillis() / 3600000L) % 24;
    }

    public int getMinutes() {
        return (int)(this.getElapsedMillis() / 60000L) % 60;
    }

    public int getSeconds() {
        return (int)(this.getElapsedMillis() / 1000L) % 60;
    }

    public int getMilliseconds() {
        return (int)this.getElapsedMillis() % 1000;
    }

    public boolean isZero() {
        return this.getHours() == 0 && this.getMinutes() == 0 && this.getSeconds() == 0 && this.getMilliseconds() == 0;
    }

    private long getElapsedMillis() {
        return this.running ? System.currentTimeMillis() - this.startTimeMillis : this.elapsedBeforePause;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.running) {
            return;
        }
        if (this.elapsedBeforePause != 0L) {
            this.startTimeMillis = System.currentTimeMillis() - this.elapsedBeforePause;
            this.elapsedBeforePause = 0L;
        } else {
            this.startTimeMillis = System.currentTimeMillis();
        }
        this.running = true;
    }

    public void pause() {
        if (!this.running) {
            return;
        }
        this.elapsedBeforePause = System.currentTimeMillis() - this.startTimeMillis;
        this.running = false;
    }

    public void reset() {
        this.running = false;
        this.startTimeMillis = 0L;
        this.elapsedBeforePause = 0L;
    }
}

