/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import com.wynntils.core.WynntilsMod;
import com.wynntils.utils.MD5Verification;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.util.Objects;
import java.util.function.Consumer;

public final class FileUtils {
    public static void mkdir(File dir) {
        if (dir.isDirectory()) {
            return;
        }
        if (!dir.mkdirs()) {
            WynntilsMod.error("Directory " + String.valueOf(dir) + " could not be created");
        }
    }

    public static void createNewFile(File file) {
        if (file.isFile()) {
            assert (false);
            return;
        }
        try {
            if (!file.createNewFile()) {
                WynntilsMod.error("File " + String.valueOf(file) + " could not be created");
            }
        }
        catch (IOException e) {
            WynntilsMod.error("IOException while created File " + String.valueOf(file));
        }
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            WynntilsMod.error("File " + String.valueOf(file) + " could not be deleted");
        }
    }

    public static void deleteFolder(File folder) {
        if (!folder.exists()) {
            return;
        }
        for (File file : Objects.requireNonNullElse(folder.listFiles(), new File[0])) {
            if (file.isDirectory()) {
                FileUtils.deleteFolder(file);
                continue;
            }
            FileUtils.deleteFile(file);
        }
        if (!folder.delete()) {
            WynntilsMod.error("Folder " + String.valueOf(folder) + " could not be deleted");
        }
    }

    public static void moveFile(File sourceFile, File destFile) {
        try {
            org.apache.commons.io.FileUtils.moveFile((File)sourceFile, (File)destFile);
        }
        catch (IOException exception) {
            WynntilsMod.error("Move file " + String.valueOf(sourceFile) + " to " + String.valueOf(destFile) + " failed");
        }
    }

    public static void tryCopyFile(File sourceFile, File destFile) {
        try {
            FileUtils.copyFile(sourceFile, destFile);
        }
        catch (IOException e) {
            WynntilsMod.error("Copy file " + String.valueOf(sourceFile) + " to " + String.valueOf(destFile) + " failed");
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (sourceFile == null || destFile == null) {
            throw new IllegalArgumentException("Argument files should not be null.");
        }
        try {
            org.apache.commons.io.FileUtils.copyFile((File)sourceFile, (File)destFile);
        }
        catch (FileSystemException exception) {
            FileUtils.copyFileWindows(sourceFile, destFile);
        }
    }

    private static void copyFileWindows(File sourceFile, File destFile) {
        try (FileInputStream inputStream = new FileInputStream(sourceFile);
             FileChannel source = inputStream.getChannel();
             FileOutputStream outputStream = new FileOutputStream(destFile);
             FileChannel destination = outputStream.getChannel();){
            destination.transferFrom(source, 0L, source.size());
        }
        catch (Exception e) {
            WynntilsMod.warn("Failed to copy file " + String.valueOf(sourceFile) + " to " + String.valueOf(destFile), e);
        }
    }

    public static String getMd5(File file) {
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("Argument file should not be null or a directory.");
        }
        MD5Verification verification = new MD5Verification(file);
        return verification.getMd5();
    }

    public static void downloadFileWithProgress(URLConnection connection, File fileDestination, Consumer<Float> progressCallback) {
        try {
            int bytesRead;
            int fileSize = connection.getContentLength();
            FileUtils.createNewFile(fileDestination);
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            FileOutputStream outputStream = new FileOutputStream(fileDestination);
            byte[] buffer = new byte[8192];
            long totalBytesRead = 0L;
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
                if (fileSize <= 0) continue;
                float progress = (float)totalBytesRead / (float)fileSize;
                progressCallback.accept(Float.valueOf(progress));
            }
            outputStream.close();
        }
        catch (IOException exception) {
            fileDestination.delete();
            WynntilsMod.error("Exception whilst downloading file", exception);
        }
    }
}

